/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.DoubleDataSource;

public class BufferedDoubleDataSource
extends BaseDoubleDataSource {
    public static final int DEFAULT_BUFFERSIZE = 8192;
    protected double[] buf;
    protected int readPos = 0;
    protected int writePos = 0;
    protected InlineDataProcessor dataProcessor = null;

    public BufferedDoubleDataSource(double[] inputData) {
        this(inputData, null);
    }

    public BufferedDoubleDataSource(double[] inputData, InlineDataProcessor dataProcessor) {
        this.buf = new double[inputData.length];
        System.arraycopy(inputData, 0, this.buf, 0, this.buf.length);
        this.writePos = this.buf.length;
        this.dataLength = this.buf.length;
        this.dataProcessor = dataProcessor;
        if (dataProcessor != null) {
            dataProcessor.applyInline(this.buf, 0, this.writePos);
        }
    }

    public BufferedDoubleDataSource(DoubleDataSource inputSource) {
        this(inputSource, null);
    }

    public BufferedDoubleDataSource(DoubleDataSource inputSource, InlineDataProcessor dataProcessor) {
        super(inputSource);
        this.buf = new double[8192];
        this.dataProcessor = dataProcessor;
    }

    @Override
    public boolean hasMoreData() {
        return this.currentlyInBuffer() > 0 || this.inputSource != null && this.inputSource.hasMoreData();
    }

    public int currentlyInBuffer() {
        assert (this.writePos >= this.readPos);
        return this.writePos - this.readPos;
    }

    @Override
    public int available() {
        int available = this.currentlyInBuffer();
        if (this.inputSource != null) {
            available += this.inputSource.available();
        }
        return available;
    }

    protected int bufferSpaceLeft() {
        return this.buf.length - this.currentlyInBuffer();
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        if (this.currentlyInBuffer() < length) {
            this.readIntoBuffer(length - this.currentlyInBuffer());
        }
        int toDeliver = length;
        if (this.currentlyInBuffer() < length) {
            toDeliver = this.currentlyInBuffer();
        }
        System.arraycopy(this.buf, this.readPos, target, targetPos, toDeliver);
        this.readPos += toDeliver;
        return toDeliver;
    }

    protected boolean readIntoBuffer(int minLength) {
        if (this.inputSource == null) {
            return false;
        }
        if (!this.inputSource.hasMoreData()) {
            return false;
        }
        if (this.bufferSpaceLeft() < minLength) {
            this.increaseBufferSize(minLength + this.currentlyInBuffer());
        } else if (this.buf.length - this.writePos < minLength) {
            this.compact();
        }
        int readSum = 0;
        readSum = this.inputSource.getData(this.buf, this.writePos, minLength);
        this.writePos += readSum;
        if (this.dataProcessor != null) {
            this.dataProcessor.applyInline(this.buf, this.writePos - readSum, readSum);
        }
        return readSum == minLength;
    }

    protected void increaseBufferSize(int minSize) {
        int newLength = this.buf.length;
        while (newLength < minSize) {
            newLength *= 2;
        }
        double[] newBuf = new double[newLength];
        int avail = this.currentlyInBuffer();
        System.arraycopy(this.buf, this.readPos, newBuf, 0, avail);
        this.buf = newBuf;
        this.readPos = 0;
        this.writePos = avail;
    }

    protected void compact() {
        if (this.readPos == 0) {
            return;
        }
        int avail = this.writePos - this.readPos;
        System.arraycopy(this.buf, this.readPos, this.buf, 0, avail);
        this.readPos = 0;
        this.writePos = avail;
    }
}

