/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import marytts.util.io.General;

public class ESTTrackWriter {
    private float[] times = null;
    private float[][] frames = null;
    private String feaType = "";

    public ESTTrackWriter(float[] setTimes, float[][] setFrames, String setFeaType) {
        this.times = setTimes;
        this.frames = setFrames;
        this.feaType = setFeaType;
    }

    public void doWriteAndClose(String fName, boolean isBinary, boolean isBigEndian) throws IOException {
        int i;
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't open file [" + fName + "] for writing.", e);
        }
        dos.writeBytes("EST_File Track\n");
        if (isBinary) {
            dos.writeBytes("DataType binary\n");
            if (isBigEndian) {
                dos.writeBytes("ByteOrder 10\n");
            } else {
                dos.writeBytes("ByteOrder 01\n");
            }
        } else {
            dos.writeBytes("DataType ascii\n");
        }
        int numChannels = this.frames != null && this.frames.length > 0 && this.frames[0] != null ? this.frames[0].length : 0;
        dos.writeBytes("NumFrames " + this.times.length + "\n" + "NumChannels " + numChannels + "\n" + "NumAuxChannels 0\n" + "EqualSpace 0\n" + "BreaksPresent true\n" + "CommentChar ;\n");
        int k = 0;
        while (k < numChannels) {
            String K = Integer.toString(k);
            dos.writeBytes("Channel_" + K + " " + this.feaType + "_" + K + "\n");
            ++k;
        }
        dos.writeBytes("EST_Header_End\n");
        if (isBinary) {
            i = 0;
            while (i < this.times.length) {
                General.writeFloat((DataOutputStream)dos, (boolean)isBigEndian, (float)this.times[i]);
                General.writeFloat((DataOutputStream)dos, (boolean)isBigEndian, (float)1.0f);
                int k2 = 0;
                while (k2 < numChannels) {
                    General.writeFloat((DataOutputStream)dos, (boolean)isBigEndian, (float)this.frames[i][k2]);
                    ++k2;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.times.length) {
                dos.writeBytes(Float.toString(this.times[i]));
                dos.writeBytes("\t1\t");
                if (numChannels > 0) {
                    dos.writeBytes(Float.toString(this.frames[i][0]));
                    int k3 = 1;
                    while (k3 < this.frames[0].length) {
                        dos.writeBytes(" " + Float.toString(this.frames[i][k3]));
                        ++k3;
                    }
                }
                dos.writeBytes("\n");
                ++i;
            }
        }
        dos.flush();
        dos.close();
    }
}

