/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioCommon {
    private static boolean DEBUG = false;

    public static void setDebug(boolean bDebug) {
        DEBUG = bDebug;
    }

    public static void listSupportedTargetTypes() {
        StringBuilder strMessage = new StringBuilder("Supported target types:");
        AudioFileFormat.Type[] aTypes = AudioSystem.getAudioFileTypes();
        int i = 0;
        while (i < aTypes.length) {
            strMessage.append(" ").append(aTypes[i].getExtension());
            ++i;
        }
        AudioCommon.out(strMessage.toString());
    }

    public static AudioFileFormat.Type findTargetType(String strExtension) {
        AudioFileFormat.Type[] aTypes = AudioSystem.getAudioFileTypes();
        int i = 0;
        while (i < aTypes.length) {
            if (aTypes[i].getExtension().equals(strExtension)) {
                return aTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static void listMixersAndExit() {
        AudioCommon.out("Available Mixers:");
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < aInfos.length) {
            AudioCommon.out(aInfos[i].getName());
            ++i;
        }
        if (aInfos.length == 0) {
            AudioCommon.out("[No mixers available]");
        }
        System.exit(0);
    }

    public static void listMixersAndExit(boolean bPlayback) {
        AudioCommon.out("Available Mixers:");
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < aInfos.length) {
            Line.Info lineInfo;
            Mixer mixer = AudioSystem.getMixer(aInfos[i]);
            if (mixer.isLineSupported(lineInfo = new Line.Info(bPlayback ? SourceDataLine.class : TargetDataLine.class))) {
                AudioCommon.out(aInfos[i].getName());
            }
            ++i;
        }
        if (aInfos.length == 0) {
            AudioCommon.out("[No mixers available]");
        }
        System.exit(0);
    }

    public static Mixer.Info getMixerInfo(String strMixerName) {
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < aInfos.length) {
            if (aInfos[i].getName().equals(strMixerName)) {
                return aInfos[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TargetDataLine getTargetDataLine(String strMixerName, AudioFormat audioFormat, int nBufferSize) {
        TargetDataLine targetDataLine;
        block11: {
            targetDataLine = null;
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat, nBufferSize);
            try {
                if (strMixerName != null) {
                    Mixer.Info mixerInfo = AudioCommon.getMixerInfo(strMixerName);
                    if (mixerInfo == null) {
                        AudioCommon.out("AudioCommon.getTargetDataLine(): mixer not found: " + strMixerName);
                        return null;
                    }
                    Mixer mixer = AudioSystem.getMixer(mixerInfo);
                    targetDataLine = (TargetDataLine)mixer.getLine(info);
                } else {
                    if (DEBUG) {
                        AudioCommon.out("AudioCommon.getTargetDataLine(): using default mixer");
                    }
                    targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                }
                if (DEBUG) {
                    AudioCommon.out("AudioCommon.getTargetDataLine(): opening line...");
                }
                targetDataLine.open(audioFormat, nBufferSize);
                if (DEBUG) {
                    AudioCommon.out("AudioCommon.getTargetDataLine(): opened line");
                }
            }
            catch (LineUnavailableException e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block11;
                e.printStackTrace();
            }
        }
        if (DEBUG) {
            AudioCommon.out("AudioCommon.getTargetDataLine(): returning line: " + targetDataLine);
        }
        return targetDataLine;
    }

    public static boolean isPcm(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED);
    }

    private static void out(String strMessage) {
        System.out.println(strMessage);
    }
}

