/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import marytts.util.data.text.PraatTier;

public class PraatTextGrid {
    private double xmin = Double.NaN;
    private double xmax = Double.NaN;
    private Vector<PraatTier> tiers;

    public PraatTextGrid() {
        this.setTiers(new Vector<PraatTier>());
    }

    public PraatTextGrid(Vector<PraatTier> tiers) {
        this.setTiers(tiers);
    }

    public double getXmin() {
        double xmin = Double.NaN;
        for (PraatTier tier : this.tiers) {
            if (!Double.isNaN(xmin) && (Double.isNaN(tier.getXmin()) || !(tier.getXmin() < xmin))) continue;
            xmin = tier.getXmin();
        }
        return xmin;
    }

    public double getXmax() {
        double xmax = Double.NaN;
        for (PraatTier tier : this.tiers) {
            if (!Double.isNaN(xmax) && (Double.isNaN(tier.getXmax()) || !(tier.getXmax() > xmax))) continue;
            xmax = tier.getXmax();
        }
        return xmax;
    }

    public int getNumberOfTiers() {
        return this.tiers.size();
    }

    public PraatTier getTier(int index) {
        return this.tiers.get(index);
    }

    public void setTiers(Vector<PraatTier> tiers) {
        this.tiers = tiers;
    }

    public void appendTier(PraatTier tier) {
        this.tiers.add(tier);
    }

    public void writeToFile(String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        fw.append(this.toString());
        fw.close();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("File type = \"ooTextFile\"\n");
        str.append("Object class = \"TextGrid\"");
        str.append("\n");
        str.append("xmin = " + this.getXmin() + " \n");
        str.append("xmax = " + this.getXmax() + " \n");
        str.append("tiers? <exists> \n");
        str.append("size = " + this.getNumberOfTiers() + " \n");
        str.append("item []: \n");
        int t = 0;
        while (t < this.getNumberOfTiers()) {
            str.append("item [" + (t + 1) + "]:\n");
            str.append(this.getTier(t).toString());
            ++t;
        }
        return str.toString();
    }
}

