/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import de.digitalcollections.commons.file.config.SpringConfigCommonsFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={SpringConfigCommonsFile.class})
public class SpringConfigBackendImage {
    private static final Logger log = LoggerFactory.getLogger(SpringConfigBackendImage.class);

    private static void deregisterSunImageSpis() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        HashSet<String> spis = new HashSet<String>(Arrays.asList("com.sun.imageio.plugins.tiff.TIFFImageReaderSpi", "com.sun.imageio.plugins.tiff.TIFFImageWriterSpi", "com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi", "com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi", "com.sun.imageio.plugins.bmp.BMPImageReaderSpi", "com.sun.imageio.plugins.bmp.BMPImageWriterSpi"));
        for (String spi : spis) {
            try {
                Object spiProvider = registry.getServiceProviderByClass(Class.forName(spi));
                registry.deregisterServiceProvider(spiProvider);
            }
            catch (ClassNotFoundException e) {
                log.debug(e.getMessage());
            }
        }
    }

    static {
        ImageIO.setUseCache(false);
        SpringConfigBackendImage.deregisterSunImageSpis();
        CharSequence[] readerMimeTypes = ImageIO.getReaderMIMETypes();
        log.debug("ImageIO supported formats (reader): {}", (Object)String.join((CharSequence)",", readerMimeTypes));
        for (CharSequence mimeType : readerMimeTypes) {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType((String)mimeType);
            while (imageReaders.hasNext()) {
                ImageReader imageReader = imageReaders.next();
                if (imageReader == null) continue;
                log.debug("ImageReader: {} {}", (Object)mimeType, (Object)imageReader.getClass().toString());
            }
        }
        CharSequence[] writerMimeTypes = ImageIO.getWriterMIMETypes();
        log.debug("ImageIO supported formats (writer): {}", (Object)String.join((CharSequence)",", writerMimeTypes));
        for (CharSequence writerMimeType : writerMimeTypes) {
            Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType((String)writerMimeType);
            while (imageWriters.hasNext()) {
                ImageWriter imageWriter = imageWriters.next();
                if (imageWriter == null) continue;
                log.debug("ImageWriter: {} {}", (Object)writerMimeType, (Object)imageWriter.getClass().toString());
            }
        }
    }
}

