/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.jackson.serialization.PropertyValueDeserializer;
import de.digitalcollections.iiif.model.jackson.serialization.PropertyValueSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=PropertyValueSerializer.class)
@JsonDeserialize(using=PropertyValueDeserializer.class)
public class PropertyValue {
    private Map<Locale, List<String>> localizations = new LinkedHashMap<Locale, List<String>>();

    public PropertyValue() {
    }

    public PropertyValue(String first, String ... rest) {
        this(Locale.ROOT, first, rest);
    }

    public PropertyValue(Locale language, String first, String ... rest) {
        this.setValues(language, first, rest);
    }

    public void setValues(String first, String ... rest) {
        this.setValues(Locale.ROOT, first, rest);
    }

    public void setValues(Locale language, String firstValue, String ... rest) {
        Preconditions.checkNotNull((Object)language);
        Preconditions.checkNotNull((Object)firstValue);
        Preconditions.checkArgument((boolean)Arrays.stream(rest).allMatch(Objects::nonNull));
        this.localizations.put(language, new ArrayList(Lists.asList((Object)firstValue, (Object[])rest)));
    }

    public PropertyValue addValue(String first, String ... rest) {
        return this.addValue(Locale.ROOT, first, rest);
    }

    public PropertyValue addValue(Locale language, String first, String ... rest) {
        if (this.localizations.containsKey(language)) {
            this.localizations.get(language).addAll(Lists.asList((Object)first, (Object[])rest));
        } else {
            this.setValues(language, first, rest);
        }
        return this;
    }

    public Set<Locale> getLocalizations() {
        return this.localizations.keySet();
    }

    public List<String> getValues() {
        Locale defaultLang = Locale.getDefault();
        if (this.localizations.containsKey(defaultLang)) {
            return this.localizations.get(defaultLang);
        }
        if (this.localizations.containsKey(Locale.ROOT)) {
            return this.localizations.get(Locale.ROOT);
        }
        if (this.localizations.size() > 0) {
            return this.localizations.entrySet().iterator().next().getValue();
        }
        return Collections.emptyList();
    }

    public List<String> getValues(Locale locale) {
        return this.localizations.get(locale);
    }

    public String getFirstValue() {
        if (this.getValues() == null) {
            return null;
        }
        return this.getValues().get(0);
    }

    public String getFirstValue(Locale locale) {
        List<String> values = this.getValues(locale);
        if (values == null) {
            return this.getFirstValue();
        }
        return values.get(0);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<Locale, List<String>> e : this.localizations.entrySet()) {
            String language = e.getKey().toLanguageTag();
            String values = e.getValue().size() == 1 ? e.getValue().get(0) : "{" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)e.getValue()) + "}";
            out.append(String.format("%s=%s", language, values));
        }
        return String.format("PropertyValue(%s)", out.toString());
    }
}

