/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import de.digitalcollections.iiif.model.jackson.IiifModule;
import de.digitalcollections.iiif.model.jackson.ProblemHandler;

public class IiifObjectMapper
extends ObjectMapper {
    private void checkJacksonVersion() {
        int neededMajor = 2;
        int neededMinor = 9;
        int currentMajor = this.version().getMajorVersion();
        int currentMinor = this.version().getMinorVersion();
        if (currentMajor < neededMajor || currentMajor == neededMajor && currentMinor < neededMinor) {
            throw new RuntimeException(String.format("iiif-apis requires Jackson >= 2.9.0. The version on your classpath is %s", this.version().toString()));
        }
    }

    public IiifObjectMapper() {
        this.checkJacksonVersion();
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.disable(SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.addHandler(new ProblemHandler());
        this.registerModule((Module)new JavaTimeModule());
        this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.registerModule((Module)new ParameterNamesModule());
        this.registerModule((Module)new IiifModule());
    }

    private IiifObjectMapper(IiifObjectMapper objectMapper) {
        super((ObjectMapper)objectMapper);
    }

    public ObjectMapper copy() {
        return new IiifObjectMapper(this);
    }
}

