/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.model.sharedcanvas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.digitalcollections.iiif.model.enums.ViewingDirection;
import de.digitalcollections.iiif.model.enums.ViewingHint;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Sequence
extends Resource<Sequence> {
    public static final String TYPE = "sc:Sequence";
    private ViewingDirection viewingDirection;
    private URI startCanvas;
    private List<Canvas> canvases;

    @JsonCreator
    public Sequence(@JsonProperty(value="@id") String identifier) {
        super(identifier);
    }

    public Sequence(String identifier, String label) {
        this(identifier);
        this.addLabel(label, new String[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public ViewingDirection getViewingDirection() {
        return this.viewingDirection;
    }

    public void setViewingDirection(ViewingDirection viewingDirection) {
        this.viewingDirection = viewingDirection;
    }

    @Override
    @JsonIgnore
    public Set<ViewingHint.Type> getSupportedViewingHintTypes() {
        return ImmutableSet.of((Object)((Object)ViewingHint.Type.INDIVIDUALS), (Object)((Object)ViewingHint.Type.PAGED), (Object)((Object)ViewingHint.Type.CONTINUOUS));
    }

    public List<Canvas> getCanvases() {
        return this.canvases;
    }

    public void setCanvases(List<Canvas> canvases) {
        this.canvases = canvases;
    }

    public Sequence addCanvas(Canvas first, Canvas ... rest) {
        if (this.canvases == null) {
            this.canvases = new ArrayList<Canvas>();
        }
        this.canvases.addAll(Lists.asList((Object)first, (Object[])rest));
        return this;
    }

    public URI getStartCanvas() {
        return this.startCanvas;
    }

    public void setStartCanvas(URI startCanvas) {
        this.startCanvas = startCanvas;
    }
}

