/*
 * Decompiled with CFR 0.152.
 */
package de.ebf;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import de.ebf.AbstractOneSkyAppMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="get-translations", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class GetTranslationsOneSkyAppMojo
extends AbstractOneSkyAppMojo {
    @Parameter(property="sourceFileName")
    private List<String> sourceFileNames;
    @Parameter(property="locales")
    private List<String> locales;
    @Parameter(property="outputDir", required=true)
    private File outputDir;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.sourceFileNames == null || this.sourceFileNames.isEmpty() || this.locales == null || this.locales.isEmpty()) {
            this.showHelp();
        }
        this.getTranslations();
    }

    private void getTranslations() throws MojoExecutionException {
        try {
            for (String sourceFileName : this.sourceFileNames) {
                for (String locale : this.locales) {
                    System.out.println(String.format("Downloading %1s translations for %2s", locale, sourceFileName));
                    OkHttpClient okHttpClient = new OkHttpClient();
                    String url = String.format("https://platform.api.onesky.io/1/projects/%1$s/translations?locale=%2$s&source_file_name=%3$s&%4$s", this.projectId, locale, sourceFileName, this.getAuthParams());
                    Request request = new Request.Builder().get().url(url).build();
                    Response response = okHttpClient.newCall(request).execute();
                    if (response.code() == 200) {
                        if (!this.outputDir.exists()) {
                            this.outputDir.mkdirs();
                        }
                        String targetFileName = sourceFileName + "_" + locale;
                        int index = sourceFileName.lastIndexOf(".");
                        if (index > 0) {
                            targetFileName = sourceFileName.substring(0, index) + "_" + locale + "." + sourceFileName.substring(index + 1);
                        }
                        File outputFile = new File(this.outputDir, targetFileName);
                        outputFile.createNewFile();
                        InputStream inputStream = response.body().byteStream();
                        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                        System.out.println(String.format("Successfully downloaded %1s translation for %2s to %3s", locale, sourceFileName, outputFile.getName()));
                        continue;
                    }
                    throw new MojoExecutionException(String.format("OneSkyApp API returned %1$s: %2s", response.code(), response.message()));
                }
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

