/*
 * Decompiled with CFR 0.152.
 */
package de.ebf;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import de.ebf.AbstractOneSkyAppMojo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="upload-files", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class UploadFileOneSkyAppMojo
extends AbstractOneSkyAppMojo {
    @Parameter(property="outputDir", required=true)
    private List<File> files;
    @Parameter(property="locale")
    private String locale;
    @Parameter(property="fileFormat")
    private String fileFormat;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.files == null || this.files.isEmpty() || this.locale == null || this.fileFormat == null) {
            this.showHelp();
        }
        this.uploadFiles();
    }

    private void uploadFiles() throws MojoExecutionException {
        try {
            for (File file : this.files) {
                System.out.println(String.format("Uploading %1$s", file.getName()));
                OkHttpClient okHttpClient = new OkHttpClient();
                String url = String.format("https://platform.api.onesky.io/1/projects/%1$s/files?file_format=%2$s&locale=%3$s&%4$s", this.projectId, this.fileFormat, this.locale, this.getAuthParams());
                RequestBody requestBody = new MultipartBuilder().type(MultipartBuilder.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\"; filename=\"" + file.getName() + "\""}), RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (File)file)).build();
                Request request = new Request.Builder().post(requestBody).url(url).build();
                Response response = okHttpClient.newCall(request).execute();
                if (response.code() == 201) {
                    System.out.println(String.format("Successfully uploaded %1$s", file.getName()));
                    continue;
                }
                throw new MojoExecutionException(String.format("OneSkyApp API returned %1$s: %2s, %3$s", response.code(), response.message(), response.body().string()));
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

