/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.jacksonbukkit;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import de.eldoria.jacksonbukkit.JacksonBukkitModule;
import de.eldoria.jacksonbukkit.builder.JacksonBukkitBuilder;
import de.eldoria.jacksonbukkit.deserializer.HexRGBColorDeserializer;
import de.eldoria.jacksonbukkit.deserializer.LegacyItemStackDeserializer;
import de.eldoria.jacksonbukkit.deserializer.RGBColorDeserializer;
import de.eldoria.jacksonbukkit.serializer.HexRGBColorSerializer;
import de.eldoria.jacksonbukkit.serializer.LegacyItemStackSerializer;
import de.eldoria.jacksonbukkit.serializer.RGBColorSerializer;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public class JacksonBukkit
extends JacksonBukkitModule {
    @ApiStatus.Internal
    public JacksonBukkit(boolean hexColors) {
        super(hexColors);
    }

    public String getModuleName() {
        return "JacksonBukkit";
    }

    @ApiStatus.Internal
    public JacksonBukkit() {
        this(false);
    }

    protected void registerDeserializer(SimpleDeserializers deserializers) {
        deserializers.addDeserializer(ItemStack.class, (JsonDeserializer)new LegacyItemStackDeserializer());
        deserializers.addDeserializer(Color.class, (JsonDeserializer)(this.hexColors ? new HexRGBColorDeserializer() : new RGBColorDeserializer()));
    }

    protected void registerSerializer(SimpleSerializers serializers) {
        serializers.addSerializer(ItemStack.class, (JsonSerializer)new LegacyItemStackSerializer());
        serializers.addSerializer(Color.class, (JsonSerializer)(this.hexColors ? new HexRGBColorSerializer() : new RGBColorSerializer()));
    }

    public static JacksonBukkitBuilder builder() {
        return new JacksonBukkitBuilder();
    }
}

