/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.jacksonbukkit;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import de.eldoria.jacksonbukkit.JacksonBukkitModule;
import de.eldoria.jacksonbukkit.builder.JacksonPaperBuilder;
import de.eldoria.jacksonbukkit.deserializer.HexRGBAColorDeserializer;
import de.eldoria.jacksonbukkit.deserializer.LegacyItemStackDeserializer;
import de.eldoria.jacksonbukkit.deserializer.PaperItemStackDeserializer;
import de.eldoria.jacksonbukkit.deserializer.RGBAColorDeserializer;
import de.eldoria.jacksonbukkit.serializer.HexPaperColorSerializer;
import de.eldoria.jacksonbukkit.serializer.LegacyItemStackSerializer;
import de.eldoria.jacksonbukkit.serializer.PaperColorSerializer;
import de.eldoria.jacksonbukkit.serializer.PaperItemStackSerializer;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class JacksonPaper
extends JacksonBukkitModule {
    private final boolean legacyItemStackSerialization;
    @Nullable
    private final JsonDeserializer<Component> componentDeserializer;
    @Nullable
    private final JsonSerializer<Component> componentSerializer;

    @ApiStatus.Internal
    public JacksonPaper(boolean hexColors, boolean legacyItemStackSerialization, @Nullable JsonDeserializer<Component> componentDeserializer, @Nullable JsonSerializer<Component> componentSerializer) {
        super(hexColors);
        this.legacyItemStackSerialization = legacyItemStackSerialization;
        this.componentDeserializer = componentDeserializer;
        this.componentSerializer = componentSerializer;
    }

    @ApiStatus.Internal
    public JacksonPaper() {
        super(false);
        this.legacyItemStackSerialization = false;
        this.componentDeserializer = null;
        this.componentSerializer = null;
    }

    public static JacksonPaperBuilder builder() {
        return new JacksonPaperBuilder();
    }

    public String getModuleName() {
        return "JacksonPaper";
    }

    protected void registerSerializer(SimpleSerializers serializers) {
        serializers.addSerializer(ItemStack.class, (JsonSerializer)(!this.legacyItemStackSerialization ? new PaperItemStackSerializer() : new LegacyItemStackSerializer()));
        serializers.addSerializer(Color.class, this.hexColors ? new HexPaperColorSerializer() : new PaperColorSerializer());
        if (this.componentSerializer != null) {
            serializers.addSerializer(Component.class, this.componentSerializer);
        }
    }

    protected void registerDeserializer(SimpleDeserializers deserializers) {
        deserializers.addDeserializer(ItemStack.class, (JsonDeserializer)(!this.legacyItemStackSerialization ? new PaperItemStackDeserializer() : new LegacyItemStackDeserializer()));
        deserializers.addDeserializer(Color.class, this.hexColors ? new HexRGBAColorDeserializer() : new RGBAColorDeserializer());
        if (this.componentDeserializer != null) {
            deserializers.addDeserializer(Component.class, this.componentDeserializer);
        }
    }
}

