/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.jacksonbukkit.builder;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import de.eldoria.jacksonbukkit.JacksonPaper;
import de.eldoria.jacksonbukkit.builder.ModuleBuilder;
import de.eldoria.jacksonbukkit.deserializer.ComponentGsonDeserializer;
import de.eldoria.jacksonbukkit.deserializer.ComponentMiniMessageDeserializer;
import de.eldoria.jacksonbukkit.serializer.ComponentGsonSerializer;
import de.eldoria.jacksonbukkit.serializer.ComponentMiniMessageSerializer;
import de.eldoria.jacksonbukkit.util.PaperFeatures;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.Nullable;

public class JacksonPaperBuilder
extends ModuleBuilder<JacksonPaperBuilder, JacksonPaper> {
    private boolean legacyItemStackSerialization = false;
    @Nullable
    private JsonSerializer<Component> componentJsonSerializer;
    @Nullable
    private JsonDeserializer<Component> componentJsonDeserializer;

    public JacksonPaperBuilder() {
        if (PaperFeatures.HAS_MINI_MESSAGE) {
            this.componentJsonDeserializer = new ComponentMiniMessageDeserializer();
            this.componentJsonSerializer = new ComponentMiniMessageSerializer();
        } else if (PaperFeatures.HAS_ADVENTURE) {
            this.componentJsonSerializer = new ComponentGsonSerializer();
            this.componentJsonDeserializer = new ComponentGsonDeserializer();
        }
    }

    public JacksonPaperBuilder useLegacyItemStackSerialization() {
        this.legacyItemStackSerialization = true;
        return this;
    }

    public JacksonPaperBuilder withMiniMessages(MiniMessage miniMessage) {
        this.componentJsonSerializer = new ComponentMiniMessageSerializer(miniMessage);
        this.componentJsonDeserializer = new ComponentMiniMessageDeserializer(miniMessage);
        return this;
    }

    public JacksonPaperBuilder withMiniMessages() {
        this.componentJsonSerializer = new ComponentMiniMessageSerializer();
        this.componentJsonDeserializer = new ComponentMiniMessageDeserializer();
        return this;
    }

    public JacksonPaper build() {
        return new JacksonPaper(this.hexColors, this.legacyItemStackSerialization, this.componentJsonDeserializer, this.componentJsonSerializer);
    }
}

