/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.jacksonbukkit.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.eldoria.jacksonbukkit.entities.RGBColorWrapper;
import org.bukkit.Color;

@JsonPropertyOrder(value={"format", "red", "green", "blue", "alpha"})
public final class RGBAColorWrapper
extends RGBColorWrapper {
    private final int alpha;

    @JsonCreator
    public RGBAColorWrapper(@JsonProperty(value="red") int red, @JsonProperty(value="green") int green, @JsonProperty(value="blue") int blue, @JsonProperty(value="alpha") int alpha) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public static RGBAColorWrapper of(Color color) {
        return new RGBAColorWrapper(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static RGBAColorWrapper of(String hex) {
        int red = Integer.parseInt(hex.substring(0, 2), 16);
        int green = Integer.parseInt(hex.substring(2, 4), 16);
        int blue = Integer.parseInt(hex.substring(4, 6), 16);
        int alpha = hex.length() == 8 ? Integer.parseInt(hex.substring(6, 8), 16) : 255;
        return new RGBAColorWrapper(red, green, blue, alpha);
    }

    public String asHex() {
        return "%02X%02X%02X%02X".formatted(this.red(), this.green(), this.blue(), this.alpha);
    }

    public Color toBukkitColor() {
        return Color.fromARGB((int)this.alpha, (int)this.red(), (int)this.green(), (int)this.blue());
    }

    @JsonProperty
    public int alpha() {
        return this.alpha;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RGBAColorWrapper that = (RGBAColorWrapper)((Object)o);
        return this.alpha == that.alpha;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.alpha;
        return result;
    }

    public String toString() {
        return "RGBAColorWrapper[red=%d, green=%d, blue=%d, alpha=%d]".formatted(this.red(), this.green(), this.blue(), this.alpha);
    }
}

