/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.eldoria.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.eldoutilities.utils.ArrayUtil;
import de.eldoria.eldoutilities.utils.Parser;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;

public final class Completion {
    public static final long OFFLINE_PLAYER_CACHE_SIZE = 1000L;
    private static final Set<String> PLAYER_NAMES = new HashSet<String>();
    private static final Set<String> ONLINE_NAMES = new HashSet<String>();
    private static final Set<String> SMART_MATS;
    private static final Map<String, List<String>> SMART_SHORT_MATS;
    private static final Map<String, List<String>> SMART_PART_MATS;
    private static final Pattern SHORT_NAME;
    private static final Cache<String, List<String>> SMART_MAT_RESULTS;
    private static Instant lastPlayerRefresh;

    private Completion() {
        throw new UnsupportedOperationException("This is a utility class.");
    }

    private static String getShortName(Material mat) {
        Matcher matcher = SHORT_NAME.matcher(mat.name());
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            builder.append(matcher.group(1));
        }
        return builder.toString();
    }

    private static Set<String> getParts(Material mat) {
        return Arrays.stream(mat.name().split("_")).collect(Collectors.toSet());
    }

    public static List<String> completeMaterial(String value, boolean lowerCase) {
        value = value.toLowerCase(Locale.ROOT);
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (Map.Entry<String, List<String>> entry : SMART_SHORT_MATS.entrySet()) {
            if (!entry.getKey().startsWith(value)) continue;
            results.addAll((Collection)entry.getValue());
        }
        results.addAll(Completion.complete(value, SMART_MATS));
        for (Map.Entry<String, List<String>> entry : SMART_PART_MATS.entrySet()) {
            if (!entry.getKey().startsWith(value)) continue;
            results.addAll((Collection)entry.getValue());
        }
        String finalValue = value.toUpperCase(Locale.ROOT);
        results.addAll(SMART_MATS.stream().filter(mat -> mat.contains(finalValue)).collect(Collectors.toList()));
        return results.stream().map(name -> lowerCase ? name.toLowerCase(Locale.ROOT) : name).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> complete(String value, String ... inputs) {
        return ArrayUtil.startingWithInArray((String)value, (String[])inputs).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> complete(String value, Stream<String> inputs) {
        if (value.isEmpty()) {
            return inputs.collect(Collectors.toList());
        }
        String lowerValue = value.toLowerCase(Locale.ROOT);
        return inputs.filter(i -> i.toLowerCase().startsWith(lowerValue)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> complete(String value, Collection<String> inputs) {
        return Completion.complete(value, inputs.stream());
    }

    public static <T> List<String> complete(String value, Stream<T> inputs, Function<T, String> mapping) {
        return Completion.complete(value, inputs.map(mapping));
    }

    public static <T> List<String> complete(String value, Collection<T> inputs, Function<T, String> mapping) {
        return Completion.complete(value, inputs.stream(), mapping);
    }

    public static List<String> completeBoolean(String value) {
        return Completion.complete(value, "true", "false");
    }

    public static List<String> completeWorlds(String value) {
        return Completion.completeWorlds(value, ":");
    }

    public static List<String> completeWorlds(String value, String spaceReplace) {
        return Completion.complete(value, Bukkit.getWorlds(), (T w) -> w.getName().replace(" ", spaceReplace));
    }

    public static List<String> completePlayers(String value) {
        if (PLAYER_NAMES.isEmpty()) {
            PLAYER_NAMES.addAll(Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> Instant.ofEpochMilli(p.getLastPlayed()).isAfter(Instant.now().minus(30L, ChronoUnit.DAYS))).sorted(Comparator.comparingLong(OfflinePlayer::getLastPlayed)).limit(1000L).map(OfflinePlayer::getName).collect(Collectors.toSet()));
        }
        LinkedHashSet<String> complete = new LinkedHashSet<String>(Completion.complete(value, PLAYER_NAMES));
        complete.addAll(Completion.completeOnlinePlayers(value));
        return new ArrayList<String>(complete);
    }

    public static List<String> completeOnlinePlayers(String value) {
        LinkedHashSet<String> complete = new LinkedHashSet<String>(Completion.complete(value, PLAYER_NAMES));
        if (ONLINE_NAMES.isEmpty() || lastPlayerRefresh.isBefore(Instant.now().minus(10L, ChronoUnit.SECONDS))) {
            ONLINE_NAMES.clear();
            ONLINE_NAMES.addAll(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toSet()));
            lastPlayerRefresh = Instant.now();
        }
        complete.addAll(Completion.complete(value, ONLINE_NAMES.stream()));
        return new ArrayList<String>(complete);
    }

    public static <T extends Enum<T>> List<String> complete(String value, Class<T> clazz) {
        return Completion.complete(value, clazz, true, false);
    }

    public static <T extends Enum<T>> List<String> complete(String value, Class<T> clazz, boolean lowerCase, boolean strip) {
        return Completion.complete(value, Arrays.stream((Enum[])clazz.getEnumConstants()).map(Enum::name).map(v -> lowerCase ? v.toLowerCase() : v).map(v -> strip ? v.replace("_", "") : v));
    }

    public static boolean isCommand(String value, String ... command) {
        return ArrayUtil.arrayContains((String[])command, (String[])new String[]{value});
    }

    public static List<String> completeDouble(String value, double min, double max) throws CommandException {
        CommandAssertions.isDouble(value);
        Optional d = Parser.parseDouble((String)value);
        ArrayList result = new ArrayList();
        CommandAssertions.range((Double)d.get(), min, max);
        return Completion.singleEntryList(min + " \u00bb " + max);
    }

    public static List<String> completeInt(String value, int min, int max) throws CommandException {
        CommandAssertions.isInteger(value);
        Optional d = Parser.parseInt((String)value);
        CommandAssertions.range((Integer)d.get(), min, max);
        return Completion.singleEntryList(min + " \u00bb " + max);
    }

    public static List<String> completeMinDouble(String value, double min) throws CommandException {
        CommandAssertions.isDouble(value);
        Optional val = Parser.parseDouble((String)value);
        CommandAssertions.min((Double)val.get(), min);
        return Completion.singleEntryList(String.format("%.2f<", min));
    }

    public static List<String> completeMinInt(String value, int min) throws CommandException {
        CommandAssertions.isInteger(value);
        Optional val = Parser.parseInt((String)value);
        CommandAssertions.min((Integer)val.get(), min);
        return Completion.singleEntryList(min + "<");
    }

    public static List<String> completeMaxDouble(String value, double max) throws CommandException {
        CommandAssertions.isDouble(value);
        Optional val = Parser.parseDouble((String)value);
        CommandAssertions.max((Double)val.get(), max);
        return Completion.singleEntryList(String.format("%.2f", max) + ">");
    }

    public static List<String> completeMaxInt(String value, int max) throws CommandException {
        CommandAssertions.isInteger(value);
        Optional val = Parser.parseInt((String)value);
        CommandAssertions.max((Integer)val.get(), max);
        return Completion.singleEntryList(max + ">");
    }

    public static List<String> completeFreeInput(String value, int maxLength, String defaultComplete) throws CommandException {
        CommandAssertions.invalidLength(value, maxLength);
        return Completion.singleEntryList(defaultComplete);
    }

    public static <T> List<T> singleEntryList(T value) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(value);
        return list;
    }

    static {
        SHORT_NAME = Pattern.compile("(?:(?:^|_)(.))");
        SMART_MAT_RESULTS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        lastPlayerRefresh = Instant.now();
        SMART_MATS = new LinkedHashSet<String>();
        SMART_SHORT_MATS = new TreeMap<String, List<String>>();
        SMART_PART_MATS = new TreeMap<String, List<String>>();
        for (Material material : Material.values()) {
            String name = material.name();
            if (name.startsWith("LEGACY")) continue;
            SMART_SHORT_MATS.computeIfAbsent(Completion.getShortName(material).toLowerCase(Locale.ROOT), k -> new ArrayList()).add(name);
            SMART_MATS.add(name);
            for (String part : Completion.getParts(material)) {
                SMART_PART_MATS.computeIfAbsent(part.toLowerCase(Locale.ROOT), k -> new ArrayList()).add(name);
            }
        }
    }
}

