/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands.command;

import de.eldoria.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.eldoutilities.commands.command.util.Arguments;
import de.eldoria.eldoutilities.commands.exceptions.CommandException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedCommandAdapter
extends AdvancedCommand
implements TabExecutor {
    private final AdvancedCommand advancedCommand;

    private AdvancedCommandAdapter(Plugin plugin, AdvancedCommand advancedCommand) {
        super(plugin);
        this.advancedCommand = advancedCommand;
    }

    public static AdvancedCommandAdapter wrap(Plugin plugin, AdvancedCommand advancedCommand) {
        return new AdvancedCommandAdapter(plugin, advancedCommand);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        try {
            this.executeCommand(sender, label, args);
        }
        catch (CommandException e) {
            this.handleCommandError(sender, e);
        }
        return true;
    }

    private void executeCommand(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) throws CommandException {
        Arguments arguments = Arguments.create(this.plugin(), sender, args);
        this.advancedCommand.commandRoute(sender, label, arguments);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List<String> strings;
        Arguments arguments = Arguments.create(this.plugin(), sender, args);
        try {
            strings = this.advancedCommand.tabCompleteRoute(sender, label, arguments);
        }
        catch (CommandException e) {
            strings = Collections.singletonList(this.messageSender().translatePlain(e.getMessage(), new TagResolver[]{e.replacements()}));
            this.plugin().getLogger().log(Level.CONFIG, "Command exception occured.", e);
        }
        return strings;
    }
}

