/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands.command.util;

import de.eldoria.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.eldoutilities.commands.command.CommandMeta;
import de.eldoria.eldoutilities.commands.command.util.Argument;
import de.eldoria.eldoutilities.commands.command.util.Arguments;
import de.eldoria.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.eldoutilities.messages.Replacement;
import de.eldoria.eldoutilities.utils.EnumUtil;
import de.eldoria.eldoutilities.utils.Parser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public final class CommandAssertions {
    private CommandAssertions() {
        throw new UnsupportedOperationException("This is a utility class.");
    }

    public static void unexpectedRouteEnd(CommandMeta meta, Arguments arguments) throws CommandException {
        if (arguments.isEmpty() && meta.defaultCommand() == null) {
            String subcommands = meta.subCommands().values().stream().map(c -> "/" + c.meta().createCommandCall()).collect(Collectors.joining("\n"));
            throw CommandException.message("error.endOfRoute", Replacement.create((String)"COMMANDS", (String)subcommands));
        }
    }

    public static void unexpectedRouteEnd(CommandMeta meta, Optional<AdvancedCommand> command) throws CommandException {
        if (command.isEmpty()) {
            String subcommands = meta.subCommands().values().stream().map(c -> "/" + c.meta().createCommandCall()).collect(Collectors.joining("\n"));
            throw CommandException.message("error.endOfRoute", Replacement.create((String)"COMMANDS", (String)subcommands));
        }
    }

    public static void invalidArguments(CommandMeta meta, String[] args) throws CommandException {
        CommandAssertions.isFalse(args.length < meta.requiredArguments(), "error.invalidArguments", Replacement.create((String)"SYNTAX", (String)(meta.name() + " " + meta.argumentString())));
    }

    public static void invalidArguments(CommandMeta meta, Arguments args) throws CommandException {
        CommandAssertions.isFalse(args.size() < meta.requiredArguments(), "error.invalidArguments", Replacement.create((String)"SYNTAX", (String)(meta.createCommandCall() + " " + meta.argumentString())));
    }

    public static void invalidArguments(CommandMeta meta, Arguments arguments, Argument ... args) throws CommandException {
        long required = Arrays.stream(args).filter(Argument::isRequired).count();
        String argumentString = Arrays.stream(args).map(Argument::formatted).collect(Collectors.joining(" "));
        CommandAssertions.isFalse((long)arguments.size() < required, "error.invalidArguments", Replacement.create((String)"SYNTAX", (String)(meta.createCommandCall() + " " + argumentString)));
    }

    public static void invalidArguments(Arguments arguments, Argument ... args) throws CommandException {
        long required = Arrays.stream(args).filter(Argument::isRequired).count();
        String argumentString = Arrays.stream(args).map(Argument::formatted).collect(Collectors.joining(" "));
        CommandAssertions.isFalse((long)arguments.size() < required, "error.invalidArguments", Replacement.create((String)"SYNTAX", (String)argumentString));
    }

    public static void player(CommandSender sender) throws CommandException {
        CommandAssertions.isTrue(sender instanceof Player, "error.onlyPlayer", new TagResolver[0]);
    }

    public static void console(CommandSender sender) throws CommandException {
        CommandAssertions.isTrue(sender instanceof ConsoleCommandSender, "error.onlyConsole", new TagResolver[0]);
    }

    public static void sender(CommandSender sender, CommandMeta meta) throws CommandException {
        for (Class<? extends CommandSender> clazz : meta.allowedSender()) {
            if (!sender.getClass().isInstance(clazz)) continue;
            return;
        }
        throw CommandException.message("Invalid sender");
    }

    public static void permission(CommandSender sender, CommandMeta meta, boolean silent) throws CommandException {
        CommandAssertions.permission(sender, silent, meta.permissions().toArray(new String[0]));
    }

    public static void permission(CommandSender sender, boolean silent, String ... permissions) throws CommandException {
        if (permissions.length == 0) {
            return;
        }
        for (String permission : permissions) {
            if (!sender.hasPermission(permission)) continue;
            return;
        }
        if (silent) {
            throw CommandException.silent();
        }
        throw CommandException.message("error.permission", Replacement.create((String)"permission", (String)String.join((CharSequence)", ", permissions)));
    }

    public static void range(double value, double min, double max) throws CommandException {
        CommandAssertions.isTrue(value <= max && value >= min, "error.invalidRange", Replacement.create((String)"MIN", (Double)min), Replacement.create((String)"MAX", (Double)max));
    }

    public static void range(int value, int min, int max) throws CommandException {
        CommandAssertions.isTrue(value <= max && value >= min, "error.invalidRange", Replacement.create((String)"MIN", (Object)min), Replacement.create((String)"MAX", (Object)max));
    }

    public static void min(int value, int min) throws CommandException {
        CommandAssertions.isTrue(value >= min, "error.tooLow", Replacement.create((String)"MIN", (Object)min));
    }

    public static void min(double value, double min) throws CommandException {
        CommandAssertions.isTrue(value >= min, "error.tooLow", Replacement.create((String)"MIN", (Double)min));
    }

    public static void max(int value, int max) throws CommandException {
        CommandAssertions.isTrue(value <= max, "error.tooLarge", Replacement.create((String)"MAX", (Object)max));
    }

    public static void max(double value, double max) throws CommandException {
        CommandAssertions.isTrue(value <= max, "error.tooLarge", Replacement.create((String)"MAX", (Double)max));
    }

    public static <T extends Enum<T>> void enumValue(String value, Class<T> clazz) throws CommandException {
        CommandAssertions.isTrue(EnumUtil.parse((String)value, clazz).isPresent(), "error.invalidEnumValue", Replacement.create((String)"VALUES", (Object)Replacement.create((String)"VALUES", (String)EnumUtil.enumValues(clazz))));
    }

    public static void invalidNumber() throws CommandException {
        throw CommandException.message("error.invalidNumber");
    }

    public static void isInteger(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseInt((String)value).isPresent(), "error.invalidNumber", new TagResolver[0]);
    }

    public static void isLong(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseLong((String)value).isPresent(), "error.invalidNumber", new TagResolver[0]);
    }

    public static void isDouble(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseDouble((String)value).isPresent(), "error.invalidNumber", new TagResolver[0]);
    }

    public static void isBoolean(String value) throws CommandException {
        CommandAssertions.isTrue(Parser.parseBoolean((String)value).isPresent(), "error.invalidBoolen", new TagResolver[0]);
    }

    public static void isBoolean(String value, String isTrue, String isFalse) throws CommandException {
        CommandAssertions.isTrue(Parser.parseBoolean((String)value, (String)isTrue, (String)isFalse).isPresent(), "error.invalidBoolen", new TagResolver[0]);
    }

    public static void invalidLength(String input, int max) throws CommandException {
        CommandAssertions.isTrue(input.length() < max, "error.invalidLength", Replacement.create((String)"max", (Object)max));
    }

    public static void missingArgument(String[] args, int index) throws CommandException {
        CommandAssertions.isTrue(args.length > index, "error.missingArgument", Replacement.create((String)"index", (Object)index));
    }

    public static void missingArgument(Collection<?> args, int index) throws CommandException {
        CommandAssertions.isTrue(args.size() > index, "error.missingArgument", Replacement.create((String)"index", (Object)index));
    }

    public static void isFalse(boolean eval, String message, TagResolver ... replacements) throws CommandException {
        CommandAssertions.isTrue(!eval, message, replacements);
    }

    public static void isTrue(boolean eval, String message, TagResolver ... replacements) throws CommandException {
        if (eval) {
            return;
        }
        throw CommandException.message(message, TagResolver.resolver((TagResolver[])replacements));
    }

    public static void evalAssertSilent(boolean eval) throws CommandException {
        if (!eval) {
            return;
        }
        throw CommandException.silent();
    }

    public static void allowedSender(CommandMeta meta, CommandSender sender) throws CommandException {
        if (meta.allowedSender().isEmpty()) {
            return;
        }
        if (meta.allowedSender().contains(sender.getClass())) {
            return;
        }
        throw CommandException.message("error.invalidSender");
    }
}

