/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.utils;

import de.eldoria.eldoutilities.commands.command.util.Input;
import de.eldoria.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.eldoutilities.functions.ThrowingFunction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagContainer {
    private static final Pattern FLAG = Pattern.compile("-([a-zA-Z]+?)");
    private static final Pattern NAMED_FLAG = Pattern.compile("--([a-zA-Z-])+?");
    private final LinkedHashMap<String, Input> flags = new LinkedHashMap();
    private final List<String> flagArgs = new LinkedList<String>();
    private final Plugin plugin;
    private final String[] args;
    private String currFlag = null;
    private String lastFlag = null;
    private Input lastFlagArgs = null;

    private FlagContainer(Plugin plugin, String[] args) {
        this.plugin = plugin;
        this.args = args;
    }

    public static FlagContainer of(Plugin plugin, String[] args) {
        FlagContainer flagContainer = new FlagContainer(plugin, args);
        flagContainer.parse();
        return flagContainer;
    }

    public static boolean isFlag(String value) {
        return FLAG.matcher(value).matches() || NAMED_FLAG.matcher(value).matches();
    }

    private void parse() {
        for (String arg : this.args) {
            if (FLAG.matcher(arg).matches()) {
                this.flushFlag();
                String flag = arg.substring(1);
                if (flag.length() > 1) {
                    this.addSingleFlags(flag);
                    continue;
                }
                this.currFlag = flag;
                continue;
            }
            if (NAMED_FLAG.matcher(arg).matches()) {
                this.flushFlag();
                this.currFlag = arg.substring(2);
                continue;
            }
            if (this.currFlag == null) continue;
            this.flagArgs.add(arg);
        }
        this.flushFlag();
    }

    private void flushFlag() {
        if (this.currFlag != null) {
            this.lastFlag = this.currFlag;
            this.lastFlagArgs = this.flagArgs.isEmpty() ? null : Input.of(this.plugin, String.join((CharSequence)" ", this.flagArgs));
            this.flags.put(this.currFlag, this.flagArgs.isEmpty() ? null : Input.of(this.plugin, String.join((CharSequence)" ", this.flagArgs)));
            this.flagArgs.clear();
            this.currFlag = null;
        }
    }

    private void addSingleFlags(String flags) {
        for (char c : flags.toCharArray()) {
            this.flags.put(String.valueOf(c), null);
            this.currFlag = String.valueOf(c);
        }
    }

    public boolean has(@NotNull String flag) {
        return this.flags.containsKey(flag);
    }

    public boolean hasValue(String flag) {
        return this.flags.get(flag) != null;
    }

    public <T> T get(@NotNull String flag, ThrowingFunction<@Nullable Input, T, CommandException> map) throws CommandException {
        Input input = this.get(flag);
        return (T)map.apply((Object)input);
    }

    @Nullable
    public Input get(String flag) {
        return this.flags.get(flag);
    }

    public Optional<Input> getIfPresent(String flag) {
        return Optional.ofNullable(this.get(flag));
    }

    public <T> Optional<T> getIfPresent(@NotNull String flag, Function<Input, T> map) {
        return this.getIfPresent(flag).map(map);
    }

    public String lastFlag() {
        return this.lastFlag;
    }

    public Input lastFlagArgs() {
        return this.lastFlagArgs;
    }

    public boolean hasLastFlagArg() {
        return this.lastFlagArgs != null;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty();
    }
}

