/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands.command;

import de.eldoria.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.eldoutilities.commands.command.util.Argument;
import de.eldoria.eldoutilities.commands.command.util.CommandMetaBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class CommandMeta {
    private final String name;
    private final String[] aliases;
    private final Set<String> permissions;
    private final Set<Class<? extends CommandSender>> allowedSender;
    private final List<Argument> arguments;
    private final AdvancedCommand defaultCommand;
    private final Map<String, AdvancedCommand> subCommands;
    private final Set<String> registeredCommands;
    private final boolean hidden;
    private final int requiredArguments;
    private AdvancedCommand parent;

    public CommandMeta(String name, String[] aliases, Set<String> permissions, Set<Class<? extends CommandSender>> allowedSender, List<Argument> arguments, AdvancedCommand defaultCommand, Map<String, AdvancedCommand> subCommands, AdvancedCommand parent, boolean hidden) {
        this.name = name;
        this.aliases = aliases;
        this.permissions = permissions;
        this.allowedSender = allowedSender;
        this.arguments = arguments;
        this.defaultCommand = defaultCommand;
        this.subCommands = subCommands;
        this.registeredCommands = subCommands.entrySet().stream().filter(e -> !((AdvancedCommand)e.getValue()).meta().isHidden()).map(Map.Entry::getKey).collect(Collectors.toSet());
        this.parent = parent;
        this.hidden = hidden;
        this.requiredArguments = (int)this.arguments().stream().filter(Argument::isRequired).count();
    }

    public static CommandMetaBuilder builder(String name) {
        return new CommandMetaBuilder(name);
    }

    public String createCommandCall() {
        ArrayList<String> calls = new ArrayList<String>();
        calls.add(this.name);
        AdvancedCommand curr = this.parent();
        while (curr != null) {
            calls.add(curr.meta().name());
            curr = curr.meta().parent();
        }
        Collections.reverse(calls);
        return String.join((CharSequence)" ", calls);
    }

    public String name() {
        return this.name;
    }

    public Set<String> permissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Set<Class<? extends CommandSender>> allowedSender() {
        return Collections.unmodifiableSet(this.allowedSender);
    }

    public List<Argument> arguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public AdvancedCommand defaultCommand() {
        return this.defaultCommand;
    }

    public Map<String, AdvancedCommand> subCommands() {
        return Collections.unmodifiableMap(this.subCommands);
    }

    public Set<String> registeredCommands() {
        return Collections.unmodifiableSet(this.registeredCommands);
    }

    public int requiredArguments() {
        return this.requiredArguments;
    }

    public String argumentString() {
        return this.arguments.stream().map(Argument::formatted).collect(Collectors.joining(" "));
    }

    protected void parent(AdvancedCommand parent) {
        this.parent = parent;
    }

    public AdvancedCommand parent() {
        return this.parent;
    }

    public boolean isCommand(String value) {
        if (value.equalsIgnoreCase(this.name())) {
            return true;
        }
        for (String alias : this.aliases) {
            if (!alias.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public CommandMetaBuilder forSubCommand(String name, AdvancedCommand parent) {
        return new CommandMetaBuilder(name).ofParent(parent);
    }

    public String[] aliases() {
        return (String[])this.aliases.clone();
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

