/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands.command.util;

import de.eldoria.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.eldoutilities.commands.command.util.Input;
import de.eldoria.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.eldoutilities.utils.ArgumentUtils;
import de.eldoria.eldoutilities.utils.FlagContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Arguments
implements Iterable<Input> {
    private static final Pattern FLAG = Pattern.compile("^-[a-zA-Z]");
    private final FlagContainer flags;
    private final Plugin plugin;
    private final CommandSender sender;
    private final String[] rawArgs;
    private final List<Input> args = new ArrayList<Input>();

    private Arguments(Plugin plugin, CommandSender sender, String[] args, FlagContainer flags) {
        this.plugin = plugin;
        this.sender = sender;
        this.rawArgs = args;
        this.flags = flags;
        this.splitArgs();
    }

    public static Arguments create(Plugin plugin, CommandSender sender, String[] args) {
        FlagContainer flags = FlagContainer.of(plugin, args);
        return new Arguments(plugin, sender, args, flags);
    }

    public void assertLength(int index) throws CommandException {
        CommandAssertions.missingArgument(this.args, index);
    }

    public boolean hasArg(int index) {
        return this.args.size() > index;
    }

    public int size() {
        return this.args.size();
    }

    public boolean sizeIs(int i) {
        return this.args.size() == i;
    }

    public boolean isEmpty() {
        return this.args.isEmpty();
    }

    public void parseQuoted() {
        this.args.clear();
        for (String s : ArgumentUtils.parseQuotedArgs((String[])this.rawArgs)) {
            if (FlagContainer.isFlag(s)) break;
            this.args.add(Input.of(this.plugin, s));
        }
    }

    public void splitArgs() {
        String s;
        Iterator iterator = Arrays.stream(this.rawArgs).collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && !FlagContainer.isFlag(s = (String)iterator.next())) {
            this.args.add(Input.of(this.plugin, s));
        }
    }

    public Input get(int index) {
        if (index < 0) {
            return this.getOrThrow(this.size() + index);
        }
        return this.getOrThrow(index);
    }

    public Input get(int index, Input def) {
        if (this.hasArg(index)) {
            return this.get(index);
        }
        return def;
    }

    private Input getOrThrow(int index) {
        CommandAssertions.missingArgument(this.args, index);
        return this.args.get(index);
    }

    @NotNull
    public String asString(int index) {
        return this.get(index).asString();
    }

    @NotNull
    public String asString(int index, String def) {
        if (this.hasArg(index)) {
            return this.asString(index);
        }
        return def;
    }

    @NotNull
    public String asString(int index, Supplier<String> def) {
        if (this.hasArg(index)) {
            return this.asString(index);
        }
        return def.get();
    }

    public int asInt(int index) throws CommandException {
        return this.get(index).asInt();
    }

    public int asInt(int index, int def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asInt(index);
        }
        return def;
    }

    public int asInt(int index, Supplier<Integer> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asInt(index);
        }
        return def.get();
    }

    public long asLong(int index) throws CommandException {
        return this.get(index).asLong();
    }

    public long asLong(int index, long def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asLong(index);
        }
        return def;
    }

    public long asLong(int index, Supplier<Long> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asLong(index);
        }
        return def.get();
    }

    public double asDouble(int index) throws CommandException {
        return this.get(index).asDouble();
    }

    public double asDouble(int index, double def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asDouble(index);
        }
        return def;
    }

    public double asDouble(int index, Supplier<Double> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asDouble(index);
        }
        return def.get();
    }

    public boolean asBoolean(int index) throws CommandException {
        return this.get(index).asBoolean();
    }

    public boolean asBoolean(int index, boolean def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asBoolean(index);
        }
        return def;
    }

    public boolean asBoolean(int index, Supplier<Boolean> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asBoolean(index);
        }
        return def.get();
    }

    public boolean asBoolean(int index, String aTrue, String aFalse, boolean def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asBoolean(index, aTrue, aFalse);
        }
        return def;
    }

    public boolean asBoolean(int index, String aTrue, String aFalse, Supplier<Boolean> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asBoolean(index, aTrue, aFalse);
        }
        return def.get();
    }

    public boolean asBoolean(int index, String aTrue, String aFalse) throws CommandException {
        return this.get(index).asBoolean(aTrue, aFalse);
    }

    @NotNull
    public Material asMaterial(int index) throws CommandException {
        return this.asMaterial(index, false);
    }

    @NotNull
    public Material asMaterial(int index, Material def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asMaterial(index);
        }
        return def;
    }

    @NotNull
    public Material asMaterial(int index, Supplier<Material> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asMaterial(index);
        }
        return def.get();
    }

    @NotNull
    public Material asMaterial(int index, boolean stripStrings) throws CommandException {
        return this.get(index).asMaterial(stripStrings);
    }

    @NotNull
    public Material asMaterial(int index, boolean stripStrings, Material def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asMaterial(index, stripStrings);
        }
        return def;
    }

    @NotNull
    public Material asMaterial(int index, boolean stripStrings, Supplier<Material> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asMaterial(index, stripStrings);
        }
        return def.get();
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz) throws CommandException {
        return this.get(index).asEnum(clazz, false);
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, T def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asEnum(index, clazz);
        }
        return def;
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, Supplier<T> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asEnum(index, clazz);
        }
        return (T)((Enum)def.get());
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, boolean stripStrings) throws CommandException {
        return this.get(index).asEnum(clazz, stripStrings);
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, boolean stripStrings, T def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asEnum(index, clazz, stripStrings);
        }
        return def;
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(int index, Class<T> clazz, boolean stripStrings, Supplier<T> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asEnum(index, clazz, stripStrings);
        }
        return (T)((Enum)def.get());
    }

    @NotNull
    public Player asPlayer(int index) throws CommandException {
        return this.get(index).asPlayer();
    }

    @NotNull
    public Player asPlayer(int index, Player def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asPlayer(index);
        }
        return def;
    }

    @NotNull
    public Player asPlayer(int index, Supplier<Player> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asPlayer(index);
        }
        return def.get();
    }

    @NotNull
    public OfflinePlayer asOfflinePlayer(int index) throws CommandException {
        return this.get(index).asOfflinePlayer();
    }

    @NotNull
    public OfflinePlayer asOfflinePlayer(int index, OfflinePlayer def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asOfflinePlayer(index);
        }
        return def;
    }

    @NotNull
    public OfflinePlayer asOfflinePlayer(int index, Supplier<OfflinePlayer> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asOfflinePlayer(index);
        }
        return def.get();
    }

    @NotNull
    public World asWorld(int index) throws CommandException {
        return this.get(index).asWorld();
    }

    @NotNull
    public World asWorld(int index, World def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asWorld(index);
        }
        return def;
    }

    @NotNull
    public World asWorld(int index, Supplier<World> def) throws CommandException {
        if (this.hasArg(index)) {
            return this.asWorld(index);
        }
        return def.get();
    }

    public List<Input> args(int from) {
        return ArgumentUtils.getRangeAsList(this.args, (int)from);
    }

    public String join() {
        return this.join(" ");
    }

    public String join(int from) {
        return this.join(" ", from);
    }

    public String join(int from, int to) {
        return this.join(" ", from, to);
    }

    public String join(String delimiter) {
        return this.args.stream().map(Input::asString).collect(Collectors.joining(delimiter));
    }

    public String join(String delimiter, int from) {
        return ArgumentUtils.getMessage(this.args.stream().map(Input::asString).collect(Collectors.toList()), (int)from);
    }

    public String join(String delimiter, int from, int to) {
        return ArgumentUtils.getMessage(this.args.stream().map(Input::asString).collect(Collectors.toList()), (int)from, (int)to);
    }

    public List<Input> args() {
        return Collections.unmodifiableList(this.args);
    }

    public Input[] asArray() {
        return this.args.toArray(new Input[0]);
    }

    public List<Input> args(int from, int to) {
        return ArgumentUtils.getRangeAsList(this.args, (int)from, (int)to);
    }

    private <T> Optional<T> parseArg(int index, Function<String, Optional<T>> map) {
        String value = this.asString(index);
        return map.apply(value);
    }

    public Arguments subArguments() {
        return this.subArguments(1);
    }

    public Arguments subArguments(int nesting) {
        return Arguments.create(this.plugin, this.sender, ArgumentUtils.getRangeAsList((Object[])this.rawArgs, (int)nesting).toArray(new String[0]));
    }

    public FlagContainer flags() {
        return this.flags;
    }

    public Input last() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    public CommandSender sender() {
        return this.sender;
    }

    @Override
    @NotNull
    public Iterator<Input> iterator() {
        return this.args().iterator();
    }

    @Override
    public Spliterator<Input> spliterator() {
        return this.args().spliterator();
    }

    public Stream<Input> stream() {
        return this.args().stream();
    }

    public Stream<Input> parallelStream() {
        return this.args().parallelStream();
    }

    public String toString() {
        return "Arguments{flags=" + this.flags + ", plugin=" + this.plugin.getName() + ", args=" + Arrays.toString(this.rawArgs) + "}";
    }
}

