/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands.command.util;

import de.eldoria.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.eldoutilities.commands.command.CommandMeta;
import de.eldoria.eldoutilities.commands.command.util.Argument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandMetaBuilder {
    private final String name;
    private final Set<String> alias = new HashSet<String>();
    private final Set<String> permissions = new HashSet<String>();
    private final Set<Class<? extends CommandSender>> allowedSender = new HashSet<Class<? extends CommandSender>>();
    private final List<Argument> arguments = new ArrayList<Argument>();
    private final Map<String, AdvancedCommand> subCommands = new HashMap<String, AdvancedCommand>();
    private AdvancedCommand defaultCommand;
    private AdvancedCommand parent;
    private boolean hidden = false;

    public CommandMetaBuilder(String name) {
        this.name = name;
    }

    public CommandMetaBuilder withPermission(String ... permission) {
        this.permissions.addAll(Arrays.asList(permission));
        return this;
    }

    public CommandMetaBuilder allowPlayer() {
        this.allowedSender.add(Player.class);
        return this;
    }

    public CommandMetaBuilder addAlias(String ... aliases) {
        this.alias.addAll(Arrays.asList(aliases));
        return this;
    }

    public CommandMetaBuilder allowConsole() {
        this.allowedSender.add(ConsoleCommandSender.class);
        return this;
    }

    @SafeVarargs
    public final CommandMetaBuilder allowCommandSender(Class<? extends CommandSender> ... senders) {
        this.allowedSender.addAll(Arrays.asList(senders));
        return this;
    }

    public CommandMetaBuilder addArgument(String name, boolean reqired) {
        this.arguments.add(Argument.input(name, reqired));
        return this;
    }

    public CommandMetaBuilder addUnlocalizedArgument(String name, boolean reqired) {
        this.arguments.add(Argument.unlocalizedInput(name, reqired));
        return this;
    }

    public CommandMetaBuilder withArguments(Argument ... arguments) {
        this.arguments.addAll(Arrays.asList(arguments));
        return this;
    }

    public CommandMetaBuilder withSubCommand(AdvancedCommand advancedCommand) {
        this.subCommands.put(advancedCommand.meta().name(), advancedCommand);
        for (String alias : advancedCommand.meta().aliases()) {
            this.subCommands.put(alias, advancedCommand);
        }
        return this;
    }

    public CommandMetaBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public CommandMetaBuilder buildSubCommands(BiConsumer<List<AdvancedCommand>, CommandMetaBuilder> commandConsumer) {
        ArrayList subCommands = new ArrayList();
        commandConsumer.accept(subCommands, this);
        for (AdvancedCommand subCommand : subCommands) {
            this.withSubCommand(subCommand);
        }
        return this;
    }

    public CommandMetaBuilder withDefaultCommand(AdvancedCommand defaultCommand) {
        this.defaultCommand = defaultCommand;
        return this;
    }

    public CommandMetaBuilder ofParent(AdvancedCommand parent) {
        this.parent = parent;
        return this;
    }

    public CommandMeta build() {
        return new CommandMeta(this.name, this.alias.toArray(new String[0]), this.permissions, this.allowedSender, this.arguments, this.defaultCommand, this.subCommands, this.parent, this.hidden);
    }

    public CommandMetaBuilder allowCommandSender(Set<Class<? extends CommandSender>> allowedSender) {
        this.allowedSender.addAll(allowedSender);
        return this;
    }

    public CommandMetaBuilder withPermission(Set<String> permissions) {
        this.permissions.addAll(permissions);
        return this;
    }
}

