/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.commands.command.util;

import de.eldoria.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.eldoutilities.messages.Replacement;
import de.eldoria.eldoutilities.utils.EnumUtil;
import de.eldoria.eldoutilities.utils.Parser;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Input {
    private final Plugin plugin;
    private final String arg;

    private Input(Plugin plugin, String arg) {
        this.plugin = plugin;
        this.arg = arg;
    }

    public static Input of(Plugin plugin, String arg) {
        return new Input(plugin, arg);
    }

    @NotNull
    public String asString() {
        return this.arg;
    }

    public int asInt() throws CommandException, IndexOutOfBoundsException {
        return (Integer)Parser.parseInt((String)this.asString()).orElseThrow(() -> CommandException.message("error.invalidNumber"));
    }

    public long asLong() throws CommandException, IndexOutOfBoundsException {
        return (Long)Parser.parseLong((String)this.asString()).orElseThrow(() -> CommandException.message("error.invalidNumber"));
    }

    public double asDouble() throws CommandException, IndexOutOfBoundsException {
        return (Double)Parser.parseDouble((String)this.asString()).orElseThrow(() -> CommandException.message("error.invalidNumber"));
    }

    public boolean asBoolean() throws CommandException, IndexOutOfBoundsException {
        return this.asBoolean("true", "false");
    }

    public boolean asBoolean(String aTrue, String aFalse) throws CommandException, IndexOutOfBoundsException {
        return (Boolean)Parser.parseBoolean((String)this.asString(), (String)aTrue, (String)aFalse).orElseThrow(() -> CommandException.message("error.invalidBoolean", Replacement.create((String)"true", (String)aTrue), Replacement.create((String)"false", (String)aFalse)));
    }

    @NotNull
    public Material asMaterial() throws CommandException, IndexOutOfBoundsException {
        return this.asMaterial(false);
    }

    @NotNull
    public Material asMaterial(boolean stripStrings) throws CommandException, IndexOutOfBoundsException {
        return (Material)EnumUtil.parse((String)this.asString(), Material.class, (boolean)stripStrings).orElseThrow(() -> CommandException.message("error.invalidMaterial"));
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(Class<T> clazz) throws CommandException, IndexOutOfBoundsException {
        return this.asEnum(clazz, false);
    }

    @NotNull
    public <T extends Enum<T>> T asEnum(Class<T> clazz, boolean stripStrings) throws CommandException, IndexOutOfBoundsException {
        return (T)((Enum)EnumUtil.parse((String)this.asString(), clazz, (boolean)stripStrings).orElseThrow(() -> CommandException.message("error.invalidEnumValue", Replacement.create((String)"VALUES", (String)EnumUtil.enumValues((Class)clazz)))));
    }

    @NotNull
    public Player asPlayer() throws CommandException, IndexOutOfBoundsException {
        Player player = this.plugin.getServer().getPlayer(this.asString());
        if (player == null) {
            throw CommandException.message("error.notOnline");
        }
        return player;
    }

    @NotNull
    public OfflinePlayer asOfflinePlayer() throws CommandException, IndexOutOfBoundsException {
        String name = this.asString();
        for (OfflinePlayer player : this.plugin.getServer().getOfflinePlayers()) {
            if (!name.equalsIgnoreCase(player.getName())) continue;
            return player;
        }
        throw CommandException.message("error.unkownPlayer");
    }

    @NotNull
    public World asWorld() throws CommandException, IndexOutOfBoundsException {
        String name = this.asString();
        World world = this.plugin.getServer().getWorld(name);
        if (world == null) {
            throw CommandException.message("error.unkownWorld");
        }
        return world;
    }
}

