/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.configuration;

import de.eldoria.eldoutilities.configuration.ExternalConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class EldoConfig {
    private static final Map<Plugin, EldoConfig> INSTANCE_CONFIG = new HashMap<Plugin, EldoConfig>();
    protected final Plugin plugin;
    private final Path pluginData;
    private final Map<String, FileConfiguration> configs = new HashMap<String, FileConfiguration>();
    private FileConfiguration config;

    public EldoConfig(Plugin plugin) {
        this.plugin = plugin;
        INSTANCE_CONFIG.putIfAbsent(plugin, this);
        this.pluginData = plugin.getDataFolder().toPath();
        this.config = plugin.getConfig();
        plugin.saveDefaultConfig();
        if (this.isMainConfig()) {
            this.init();
        }
        this.reload();
        this.save();
    }

    public static Level getLogLevel(Plugin plugin) {
        String debug;
        if (!plugin.isEnabled()) {
            String config;
            File dataFolder = plugin.getDataFolder();
            try {
                config = String.join((CharSequence)"\n", Files.readAllLines(Paths.get(dataFolder.getAbsolutePath(), "config.yml")));
            }
            catch (FileNotFoundException e) {
                return Level.INFO;
            }
            catch (IOException e) {
                Bukkit.getLogger().log(Level.INFO, "[EldoUtilities] Could not load config file. Using default log level.");
                return Level.INFO;
            }
            Pattern compile = Pattern.compile("^debug:.?([a-zA-Z].*?)$", 8);
            Matcher matcher = compile.matcher(config);
            debug = matcher.find() ? matcher.group(1) : "INFO";
        } else {
            debug = plugin.getConfig().getString("debug", "INFO");
        }
        return EldoConfig.parseLevel(debug);
    }

    private static Level parseLevel(String level) {
        return switch (level.toUpperCase()) {
            case "OFF" -> Level.OFF;
            case "SEVERE" -> Level.SEVERE;
            case "WARNING" -> Level.WARNING;
            case "DEBUG", "TRUE" -> Level.CONFIG;
            case "FINE" -> Level.FINE;
            case "FINER" -> Level.FINER;
            case "FINEST" -> Level.FINEST;
            case "ALL" -> Level.ALL;
            default -> Level.INFO;
        };
    }

    public static EldoConfig getMainConfig(Plugin plugin) {
        return INSTANCE_CONFIG.get(plugin);
    }

    public final void save() {
        this.saveConfigs();
        this.writeConfigs();
    }

    protected void saveConfigs() {
    }

    public final void reload() {
        this.readConfigs();
        this.reloadConfigs();
    }

    protected void reloadConfigs() {
    }

    private void readConfigs() {
        try {
            this.plugin.saveDefaultConfig();
            this.plugin.reloadConfig();
            this.config = this.plugin.getConfig();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load config.yml.", e);
            this.backupAndRemoveCorruptedFile(this.plugin.getDataFolder().toPath().resolve("config.yml"));
            this.readConfigs();
        }
        this.setIfAbsent("debug", "INFO");
        for (Map.Entry<String, FileConfiguration> entry : this.configs.entrySet()) {
            this.loadConfig(Paths.get(entry.getKey(), new String[0]), null, true);
        }
    }

    private void backupAndRemoveCorruptedFile(Path path) {
        Object name;
        String time = DateTimeFormatter.ofPattern("yy-MM-dd_HH.mm.ss").format(LocalDateTime.now());
        Matcher matcher = Pattern.compile("(?<name>.*)\\.(?<type>.+?)$").matcher(path.getFileName().toString());
        if (matcher.find()) {
            name = String.format("%s-%s.%s", matcher.group("name"), time, matcher.group("type"));
        } else {
            this.plugin.getLogger().severe("Could not determine file type.");
            name = path.getFileName() + time + ".backup";
        }
        Path newLoc = path.getParent().resolve((String)name);
        this.plugin.getLogger().warning("Attempting to backup " + path + " to " + newLoc);
        try {
            Files.copy(path, newLoc, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not create backup.", e);
        }
        this.plugin.getLogger().warning("Created backup at " + newLoc);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not remove old file.");
        }
        this.plugin.getLogger().warning("Removed corrupted file");
    }

    protected final boolean setIfAbsent(String path, Object value) {
        if (!this.config.isSet(path)) {
            this.config.set(path, value);
            return true;
        }
        return false;
    }

    protected final boolean setIfAbsent(ConfigurationSection section, String path, Object value) {
        if (!section.isSet(path)) {
            section.set(path, value);
            return true;
        }
        return false;
    }

    protected final FileConfiguration loadConfig(String path, @Nullable Consumer<FileConfiguration> defaultCreator, boolean reload) {
        Path configPath = this.pluginData.resolve(path + ".yml");
        return this.loadConfig(configPath, defaultCreator, reload);
    }

    protected final FileConfiguration loadConfig(Path configPath, @Nullable Consumer<FileConfiguration> defaultCreator, boolean reload) {
        try {
            return this.loadConfigWrapped(configPath, defaultCreator, reload);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load " + configPath, e);
            this.backupAndRemoveCorruptedFile(configPath);
            return this.loadConfig(configPath, defaultCreator, reload);
        }
    }

    private FileConfiguration loadConfigWrapped(Path configPath, @Nullable Consumer<FileConfiguration> defaultCreator, boolean reload) throws IOException, InvalidConfigurationException {
        YamlConfiguration load;
        this.validateMainConfigEntry();
        File configFile = configPath.toFile();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "could not create directory " + configPath.getParent().toString(), e);
            return null;
        }
        if (!configFile.exists()) {
            try {
                Files.createFile(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not create config.", e);
                return null;
            }
            YamlConfiguration config = new YamlConfiguration();
            config.load(configFile);
            if (defaultCreator != null) {
                defaultCreator.accept((FileConfiguration)config);
            }
            try {
                config.save(configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not save default config.");
                return null;
            }
        }
        if (reload) {
            load = this.load(configFile);
            return this.configs.compute(configPath.toString(), (k, v) -> load);
        }
        if (this.configs.containsKey(configPath.toString())) {
            return this.configs.get(configPath.toString());
        }
        load = this.load(configFile);
        return this.configs.computeIfAbsent(configPath.toString(), p -> load);
    }

    private YamlConfiguration load(File file) throws IOException, InvalidConfigurationException {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.load(file);
        return yamlConfiguration;
    }

    private void writeConfigs() {
        this.plugin.saveConfig();
        for (Map.Entry<String, FileConfiguration> entry : this.configs.entrySet()) {
            File file = Paths.get(entry.getKey(), new String[0]).toFile();
            if (!file.exists()) {
                try {
                    Files.createFile(file.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not create config.", e);
                    return;
                }
            }
            try {
                entry.getValue().save(file);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Could not save config " + file.getAbsolutePath(), e);
            }
        }
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public final FileConfiguration getConfig() {
        return this.config;
    }

    public final int getVersion() {
        return this.config.getInt("version", -1);
    }

    public final void setVersion(int version, boolean save) {
        this.config.set("version", (Object)version);
        if (save) {
            this.save();
        }
    }

    public Map<String, FileConfiguration> getConfigs() {
        LinkedHashMap<String, FileConfiguration> configs = new LinkedHashMap<String, FileConfiguration>();
        configs.put(Paths.get(this.plugin.getDataFolder().toPath().toString(), "config.yml").toString(), EldoConfig.getMainConfig(this.plugin).getConfig());
        configs.putAll(this.configs);
        return configs;
    }

    protected void init() {
    }

    public boolean isMainConfig() {
        return INSTANCE_CONFIG.get(this.plugin) == this;
    }

    private void validateMainConfigEntry() {
        if (!this.isMainConfig()) {
            throw new ExternalConfigException();
        }
    }
}

