/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.crossversion.builder;

import de.eldoria.eldoutilities.crossversion.ExclusiveVersionRange;
import de.eldoria.eldoutilities.crossversion.InclusiveVersionRange;
import de.eldoria.eldoutilities.crossversion.VersionRange;
import de.eldoria.eldoutilities.crossversion.builder.BiFunctionBuilder;
import de.eldoria.eldoutilities.crossversion.builder.FunctionBuilder;
import de.eldoria.eldoutilities.crossversion.builder.QuadFunctionBuilder;
import de.eldoria.eldoutilities.crossversion.builder.TriFunctionBuilder;
import de.eldoria.eldoutilities.utils.Version;
import java.util.HashMap;
import java.util.Map;

public abstract class VersionFunctionBuilder<T, V> {
    protected final Map<VersionRange, V> functions = new HashMap<VersionRange, V>();

    public static <A, R> FunctionBuilder<A, R> functionBuilder(Class<A> a, Class<R> r) {
        return new FunctionBuilder();
    }

    public static <A, B, R> BiFunctionBuilder<A, B, R> biFunctionBuilder(Class<A> a, Class<B> b, Class<R> r) {
        return new BiFunctionBuilder();
    }

    public static <A, B, C, R> TriFunctionBuilder<A, B, C, R> triFunctionBuilder(Class<A> a, Class<B> b, Class<C> c, Class<R> r) {
        return new TriFunctionBuilder();
    }

    public static <A, B, C, D, R> QuadFunctionBuilder<A, B, C, D, R> quadFunctionBuilder(Class<A> a, Class<B> b, Class<C> c, Class<D> d, Class<R> r) {
        return new QuadFunctionBuilder();
    }

    @Deprecated(forRemoval=true)
    public VersionFunctionBuilder<T, V> addVersionFunction(V function, VersionRange version) {
        this.functions.put(version, function);
        return this;
    }

    public VersionFunctionBuilder<T, V> addVersion(VersionRange version, V function) {
        this.functions.put(version, function);
        return this;
    }

    @Deprecated(forRemoval=true)
    public VersionFunctionBuilder<T, V> addVersionFunctionBetween(Version oldest, Version newest, V function) {
        this.addVersionFunction(function, new ExclusiveVersionRange(oldest, newest));
        return this;
    }

    public VersionFunctionBuilder<T, V> addExclusiveVersion(Version oldest, Version newest, V function) {
        this.addVersionFunction(function, new ExclusiveVersionRange(oldest, newest));
        return this;
    }

    public VersionFunctionBuilder<T, V> addInclusiveVersion(Version oldest, Version newest, V function) {
        this.addVersionFunction(function, new InclusiveVersionRange(oldest, newest));
        return this;
    }

    public abstract T build();
}

