/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.crossversion.function;

import de.eldoria.eldoutilities.crossversion.ServerVersion;
import de.eldoria.eldoutilities.crossversion.UnsupportedVersionException;
import de.eldoria.eldoutilities.crossversion.VersionRange;
import de.eldoria.eldoutilities.utils.Version;
import java.util.Map;
import java.util.Optional;

public class BaseVersionFunction<V> {
    private final Map<VersionRange, V> functions;

    public BaseVersionFunction(Map<VersionRange, V> functions) {
        this.functions = functions;
    }

    public V get() {
        return this.get(ServerVersion.CURRENT_VERSION);
    }

    public V get(Version version) {
        Optional<Object> first = this.functions.entrySet().stream().filter(func -> ((VersionRange)func.getKey()).contains(version)).map(Map.Entry::getValue).findFirst();
        if (first.isEmpty()) {
            throw new UnsupportedVersionException(version);
        }
        return (V)first.get();
    }
}

