/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.eldoria.EldoUtilities;
import de.eldoria.eldoutilities.debug.DebugDataProvider;
import de.eldoria.eldoutilities.debug.DebugPayload;
import de.eldoria.eldoutilities.debug.DebugSettings;
import de.eldoria.eldoutilities.debug.UserData;
import de.eldoria.eldoutilities.debug.data.DebugPayloadData;
import de.eldoria.eldoutilities.debug.data.DebugResponse;
import de.eldoria.eldoutilities.debug.data.EntryData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class DebugUtil {
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();

    private DebugUtil() {
    }

    public static void dispatchDebug(CommandSender sender, Plugin plugin, DebugSettings settings) {
        YamlConfiguration config = EldoUtilities.getConfiguration();
        if (!config.getBoolean("debugConsens", false)) {
            String message = "By using this command you agree that we will send data belonging to you to \u00a7lour server\u00a7r.\n\"\nWe will only send data when someone executes this command.\nThe data will be handled confidential from our side and will be only available by a hashed key.\nUnless you share this key no one can access it. \u00a7cEveryone who receives this key will have access to your data.\u00a7r\nYou can delete your data at every time with the deletion key. \u00a7cIf you lose or didnt save your key we can not help you.\u00a7r\nYour data will be deleted after \u00a7l\u00a7c14 days\u00a7r.\nThis data includes but is \u00a7l\u00a7cnot\u00a7r limited to:\n  - Installed Plugins and their meta data\n  - Latest log\n  - Server Informations like Worldnames and Playercount\n  - The configuration file or files of the debugged plugin\n  - Additional Data provided by our own plugins.\nWe will filter sensitive data like IPs before sending.\nHowever we \u00a7l\u00a7ccan not\u00a7r and \u00a7l\u00a7cwill not\u00a7r gurantee that we can remove all data which is considered confidential by you.\n\u00a72If you agree please execute this command once again.\n\u00a72This is a one time opt in.\nYou can opt out again in the EldoUtilities config file".stripIndent();
            sender.sendMessage(message);
            config.set("debugConsens", (Object)true);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
            Optional<DebugResponse> debugResponse = DebugUtil.sendDebug(plugin, DebugPayload.create(plugin, settings), settings);
            if (debugResponse.isPresent()) {
                String message = "Your data is available here:\n\u00a76%s/debug/v1/read/%s\u00a7r\nYou can delete it via this link:\n\u00a7c%s/debug/v1/delete/%s".formatted(settings.getHost(), debugResponse.get().getHash(), settings.getHost(), debugResponse.get().getDeletionHash());
                sender.sendMessage(message);
            } else {
                sender.sendMessage("Could not send data. Please try again later");
            }
        });
    }

    @NotNull
    public static EntryData[] getAdditionalPluginMeta(Plugin plugin) {
        LinkedList<EntryData> meta = new LinkedList<EntryData>();
        UserData userData = UserData.get((Plugin)plugin);
        meta.add(new EntryData("User Data", userData.asString()));
        if (plugin instanceof DebugDataProvider) {
            HashSet<DebugDataProvider> debuged = new HashSet<DebugDataProvider>();
            ArrayDeque<DebugDataProvider> providers = new ArrayDeque<DebugDataProvider>();
            providers.add((DebugDataProvider)plugin);
            debuged.add((DebugDataProvider)plugin);
            while (!providers.isEmpty()) {
                DebugDataProvider provider = (DebugDataProvider)providers.poll();
                for (DebugDataProvider nextProvider : provider.getDebugProviders()) {
                    if (debuged.contains(nextProvider)) {
                        plugin.getLogger().warning("Loop in debug data detected. Instance of class " + nextProvider.getClass().getSimpleName() + " returns a reference to already debugged instance of " + provider.getClass().getSimpleName());
                        continue;
                    }
                    providers.add(nextProvider);
                    debuged.add(nextProvider);
                }
                meta.addAll(Arrays.asList(provider.getDebugInformations()));
            }
        }
        return meta.toArray(new EntryData[0]);
    }

    private static Optional<DebugResponse> sendDebug(Plugin plugin, DebugPayloadData payload, DebugSettings settings) {
        Optional<DebugResponse> optional;
        HttpURLConnection con;
        try {
            URL url = new URL(settings.getHost() + "/debug/v1/submit");
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.FINEST, "Could not open connection.", e);
            return Optional.empty();
        }
        con.setRequestProperty("Content-Type", "application/json; utf-8");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        try (OutputStream outputStream = con.getOutputStream();){
            byte[] input = GSON.toJson((Object)payload).getBytes(StandardCharsets.UTF_8);
            outputStream.write(input, 0, input.length);
        }
        catch (IOException e) {
            plugin.getLogger().info("Could not write to connection.");
        }
        try {
            if (con.getResponseCode() != 200) {
                plugin.getLogger().log(Level.FINEST, "Received non 200 request for debug submission.\n" + con.getResponseMessage());
                return Optional.empty();
            }
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.INFO, "Could not read response.", e);
            return Optional.empty();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
        try {
            String responseLine;
            StringBuilder builder = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                builder.append(responseLine.trim());
            }
            optional = Optional.of((DebugResponse)GSON.fromJson(builder.toString(), DebugResponse.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.FINEST, "Could not read response.", e);
                return Optional.empty();
            }
        }
        br.close();
        return optional;
    }
}

