/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.debug.payload;

import de.eldoria.eldoutilities.debug.DebugSettings;
import de.eldoria.eldoutilities.debug.data.LogData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;

public class LogMeta
extends LogData {
    public static final int MAX_LOG_PART_SIZE = 2500;
    public static final int MAX_LOG_MB = 50;
    private static final Pattern EXCEPTION = Pattern.compile("[0-9]{2}:[0-9]{2}:[0-9]{2}] (\\[[^\\]]*?(?:ERROR|WARN)]:.*?)^\\[", 40);
    private static final String PLUGIN_LOG = "([0-9]{2}:[0-9]{2}:[0-9]{2}] \\[[^\\]]*?]: \\[[^\\]]*?name].*?)^\\[";

    public LogMeta(String log, String pluginLog, String[] internalExceptions, String[] exceptions) {
        super(log, pluginLog, internalExceptions, exceptions);
    }

    private static Pattern getPluginLog(Plugin plugin) {
        String prefix = plugin.getDescription().getPrefix();
        String name = prefix != null ? prefix : plugin.getDescription().getName();
        return Pattern.compile(PLUGIN_LOG.replace("name", name), 40);
    }

    public static LogData create(Plugin plugin, DebugSettings settings) {
        Path root = plugin.getDataFolder().toPath().toAbsolutePath().getParent().getParent();
        Path logPath = Paths.get(root.toString(), "logs", "latest.log");
        File logFile = logPath.toFile();
        String fullLog = "";
        Object latestLog = "Could not read latest log.";
        LinkedHashSet<String> pluginLog = new LinkedHashSet<String>();
        ExceptionPair exceptionPair = new ExceptionPair();
        if (logFile.exists()) {
            if (logFile.length() / 0x100000L > 50L) {
                LinkedList<String> start = new LinkedList<String>();
                FixedStack<String> end = new FixedStack<String>(2500);
                int linesReadSinceScan = 0;
                try (FileInputStream stream = new FileInputStream(logFile);
                     Scanner reader = new Scanner(stream);){
                    while (reader.hasNext()) {
                        if (start.size() < 2500) {
                            start.add(reader.nextLine());
                            if (start.size() != 2500) continue;
                            pluginLog.addAll(LogMeta.extractPluginLog(start, plugin));
                            continue;
                        }
                        end.add(reader.nextLine());
                        if (++linesReadSinceScan != 2500) continue;
                        exceptionPair.combine(LogMeta.extractExceptions(end.getLinkedList(), plugin));
                        pluginLog.addAll(LogMeta.extractPluginLog(end.getLinkedList(), plugin));
                        linesReadSinceScan = 250;
                    }
                    exceptionPair.combine(LogMeta.extractExceptions(end.getLinkedList(), plugin));
                }
                catch (IOException e) {
                    plugin.getLogger().log(Level.WARNING, "Could not read log.", e);
                }
                String startLog = String.join((CharSequence)"\n", start);
                String endLog = String.join((CharSequence)"\n", end.linkedList);
                latestLog = startLog + "\n\n[...]\n\n" + endLog;
            } else {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), StandardCharsets.UTF_8));){
                    List<String> logLines = reader.lines().collect(Collectors.toList());
                    if (logLines.size() <= 5000) {
                        latestLog = logLines.stream().collect(Collectors.joining(System.lineSeparator()));
                    } else {
                        String start = String.join((CharSequence)"\n", logLines.subList(0, 2500));
                        String end = String.join((CharSequence)"\n", logLines.subList(logLines.size() - 2500, logLines.size()));
                        latestLog = start + "\n\n[...]\n\n" + end;
                    }
                    exceptionPair.combine(LogMeta.extractExceptions(logLines, plugin));
                    pluginLog.addAll(LogMeta.extractPluginLog(logLines, plugin));
                }
                catch (IOException e) {
                    plugin.getLogger().log(Level.WARNING, "Could not read log file", e);
                }
            }
        }
        latestLog = settings.applyFilter((String)latestLog);
        String pluginlogs = settings.applyFilter(String.join((CharSequence)"", pluginLog));
        exceptionPair.applyFilter(settings);
        return new LogMeta((String)latestLog, pluginlogs, exceptionPair.getInternalArray(), exceptionPair.getExternalArray());
    }

    private static Set<String> extractPluginLog(Collection<String> log, Plugin plugin) {
        return LogMeta.extractPluginLog(String.join((CharSequence)"\n", log), plugin);
    }

    private static Set<String> extractPluginLog(String log, Plugin plugin) {
        LinkedHashSet<String> pluginLog = new LinkedHashSet<String>();
        Pattern pluginLogPattern = LogMeta.getPluginLog(plugin);
        Matcher matcher = pluginLogPattern.matcher(log);
        while (matcher.find()) {
            String match = matcher.group(1);
            pluginLog.add("[" + match);
        }
        return pluginLog;
    }

    private static ExceptionPair extractExceptions(String log, Plugin plugin) {
        String[] packages = plugin.getDescription().getMain().split("\\.");
        String project = String.join((CharSequence)".", Arrays.copyOfRange(packages, 0, Math.min(packages.length, 3)));
        LinkedHashSet<String> external = new LinkedHashSet<String>();
        LinkedHashSet<String> internal = new LinkedHashSet<String>();
        Matcher matcher = EXCEPTION.matcher(log);
        while (matcher.find()) {
            String match = matcher.group(1);
            if (match.contains(project)) {
                internal.add(match);
                continue;
            }
            external.add(match);
        }
        return new ExceptionPair(external, internal);
    }

    private static ExceptionPair extractExceptions(List<String> lines, Plugin plugin) {
        return LogMeta.extractExceptions(String.join((CharSequence)"\n", lines), plugin);
    }

    private static class ExceptionPair {
        private Set<String> external;
        private Set<String> internal;

        public ExceptionPair() {
            this.external = new LinkedHashSet<String>();
            this.internal = new LinkedHashSet<String>();
        }

        public ExceptionPair(Set<String> external, Set<String> internal) {
            this.external = new LinkedHashSet<String>(external);
            this.internal = new LinkedHashSet<String>(internal);
        }

        public Set<String> getExternal() {
            return this.external;
        }

        public Set<String> getInternal() {
            return this.internal;
        }

        public void combine(ExceptionPair pair) {
            this.external.addAll(pair.external);
            this.internal.addAll(pair.internal);
        }

        public String[] getExternalArray() {
            return this.external.toArray(new String[0]);
        }

        public String[] getInternalArray() {
            return this.internal.toArray(new String[0]);
        }

        public void applyFilter(DebugSettings settings) {
            this.external = this.external.stream().map(settings::applyFilter).collect(Collectors.toSet());
            this.internal = this.internal.stream().map(settings::applyFilter).collect(Collectors.toSet());
        }
    }

    private static class FixedStack<E> {
        private final int size;
        private final LinkedList<E> linkedList = new LinkedList();

        public FixedStack(int size) {
            this.size = size;
        }

        public boolean add(E e) {
            if (this.linkedList.size() > this.size) {
                this.linkedList.removeLast();
            }
            return this.linkedList.add(e);
        }

        public Iterator<E> iterator() {
            return this.linkedList.iterator();
        }

        public void clear() {
            this.linkedList.clear();
        }

        public ListIterator<E> listIterator() {
            return this.linkedList.listIterator();
        }

        public ListIterator<E> listIterator(int index) {
            return this.linkedList.listIterator(index);
        }

        public LinkedList<E> getLinkedList() {
            return this.linkedList;
        }
    }
}

