/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.entities;

import de.eldoria.eldoutilities.utils.AttributeUtil;
import de.eldoria.eldoutilities.utils.EMath;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityBuilder {
    private final LivingEntity entity;

    private EntityBuilder(LivingEntity entity) {
        this.entity = entity;
    }

    public static EntityBuilder of(LivingEntity entity) {
        return new EntityBuilder(entity);
    }

    public static EntityBuilder of(EntityType entity, Location location) {
        return new EntityBuilder((LivingEntity)location.getWorld().spawnEntity(location, entity));
    }

    public EntityBuilder withPassenger(Entity ... passengers) {
        for (Entity passenger : passengers) {
            this.entity.addPassenger(passenger);
        }
        return this;
    }

    public EntityBuilder withScoreboardTag(@NotNull String tag) {
        this.entity.addScoreboardTag(tag);
        return this;
    }

    public EntityBuilder withVelocity(@NotNull Vector velocity) {
        this.entity.setVelocity(velocity);
        return this;
    }

    public EntityBuilder withRotation(float yaw, float pitch) {
        this.entity.setRotation(yaw, pitch);
        return this;
    }

    public EntityBuilder withFireTicks(int ticks) {
        this.entity.setFireTicks(ticks);
        return this;
    }

    public EntityBuilder asPersistent(boolean persistent) {
        this.entity.setPersistent(persistent);
        return this;
    }

    public EntityBuilder withFallDistance(float distance) {
        this.entity.setFallDistance(distance);
        return this;
    }

    public EntityBuilder withTicksLived(int value) {
        this.entity.setTicksLived(value);
        return this;
    }

    public EntityBuilder withVisibleCustomName(boolean flag) {
        this.entity.setCustomNameVisible(flag);
        return this;
    }

    public EntityBuilder withGlowing(boolean flag) {
        this.entity.setGlowing(flag);
        return this;
    }

    public EntityBuilder asInvulnerable(boolean flag) {
        this.entity.setInvulnerable(flag);
        return this;
    }

    public EntityBuilder asSilent(boolean flag) {
        this.entity.setSilent(flag);
        return this;
    }

    public EntityBuilder withGravity(boolean gravity) {
        this.entity.setGravity(gravity);
        return this;
    }

    public EntityBuilder withMetadata(@NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        this.entity.setMetadata(metadataKey, newMetadataValue);
        return this;
    }

    public EntityBuilder withCustomName(@Nullable String name) {
        this.entity.setCustomName(name);
        return this;
    }

    public EntityBuilder withNBT(Consumer<PersistentDataContainer> change) {
        change.accept(this.entity.getPersistentDataContainer());
        return this;
    }

    public EntityBuilder withAttribute(Attribute attribute, double value) {
        AttributeUtil.setAttributeValue((LivingEntity)this.entity, (Attribute)attribute, (double)value);
        return this;
    }

    public EntityBuilder withPotionEffect(@NotNull PotionEffect effect) {
        this.entity.addPotionEffect(effect);
        return this;
    }

    public EntityBuilder withAI(boolean ai) {
        this.entity.setAI(ai);
        return this;
    }

    public EntityBuilder with(Consumer<LivingEntity> entityConsumer) {
        entityConsumer.accept(this.entity);
        return this;
    }

    public <T extends LivingEntity> EntityBuilder with(Class<T> clazz, Consumer<T> entityConsumer) {
        entityConsumer.accept(this.entity);
        return this;
    }

    public EntityBuilder setCollidable(boolean collidable) {
        this.entity.setCollidable(collidable);
        return this;
    }

    public EntityBuilder setInvisible(boolean invisible) {
        this.entity.setInvisible(invisible);
        return this;
    }

    public EntityBuilder withHealth(double health) {
        this.entity.setHealth(EMath.clamp((double)0.0, (double)AttributeUtil.getAttributeValue((LivingEntity)this.entity, (Attribute)Attribute.GENERIC_MAX_HEALTH), (double)health));
        return this;
    }

    public EntityBuilder withAbsorptionAmount(double amount) {
        this.entity.setAbsorptionAmount(amount);
        return this;
    }

    public <T extends LivingEntity> T build() {
        return (T)this.entity;
    }
}

