/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.eldoria.eldoutilities.config.ConfigKey;
import de.eldoria.eldoutilities.config.ConfigSubscriber;
import de.eldoria.eldoutilities.config.Wrapper;
import de.eldoria.eldoutilities.config.exceptions.ConfigurationException;
import de.eldoria.eldoutilities.config.template.PluginBaseConfiguration;
import de.eldoria.eldoutilities.debug.DebugDataProvider;
import de.eldoria.eldoutilities.debug.data.EntryData;
import de.eldoria.jacksonbukkit.JacksonBukkit;
import de.eldoria.jacksonbukkit.JacksonPaper;
import de.eldoria.jacksonbukkit.builder.JacksonBukkitBuilder;
import de.eldoria.jacksonbukkit.builder.JacksonPaperBuilder;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class JacksonConfig<T>
implements DebugDataProvider {
    private final Plugin plugin;
    private final ConfigKey<T> mainKey;
    private final Map<ConfigKey<?>, Object> files = new ConcurrentHashMap();
    private ObjectMapper mapper;
    private ObjectMapper writer;
    private ObjectMapper reader;

    public JacksonConfig(@NotNull Plugin plugin, @NotNull ConfigKey<T> mainKey) {
        this.plugin = plugin;
        this.mainKey = mainKey;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public T main() {
        return this.secondary(this.mainKey);
    }

    public synchronized <V> V secondary(ConfigKey<V> key) {
        if (key == PluginBaseConfiguration.KEY && !this.exists(key)) {
            CompletableFuture.delayedExecutor(10L, TimeUnit.SECONDS).execute(() -> this.files.computeIfAbsent(key, k -> this.createAndLoad(key)));
            return key.initValue().get();
        }
        return (V)this.files.computeIfAbsent(key, k -> this.createAndLoad(key));
    }

    public Wrapper<T> mainWrapped() {
        return Wrapper.of(this.mainKey, this);
    }

    public <V> Wrapper<V> secondaryWrapped(ConfigKey<V> key) {
        return Wrapper.of(key, this);
    }

    public <V> boolean exists(ConfigKey<V> key) {
        return this.resolvePath(key).toFile().exists();
    }

    public <V> boolean loaded(ConfigKey<V> key) {
        return this.files.containsKey(key);
    }

    public <V> void replace(ConfigKey<V> key, V newValue) {
        this.files.put(key, newValue);
    }

    public void save() {
        for (ConfigKey<?> configKey : this.files.keySet()) {
            this.save(configKey);
        }
    }

    public void save(ConfigKey<?> key) {
        this.write(this.resolvePath(key), this.files.get(key));
    }

    public void reload() {
        for (ConfigKey<?> key : new HashSet(this.files.keySet())) {
            this.reload(key);
        }
    }

    public void reload(ConfigKey<?> key) {
        this.files.put(key, this.createAndLoad(key));
    }

    public final ObjectMapper reader() {
        if (this.reader == null) {
            this.reader = this.registerAdditionalModules(this.createReadMapper());
        }
        return this.reader;
    }

    public final ObjectMapper writer() {
        if (this.writer == null) {
            this.writer = this.registerAdditionalModules(this.createWriteMapper());
        }
        return this.writer;
    }

    public final ObjectMapper mapper() {
        if (this.mapper == null) {
            this.mapper = this.registerAdditionalModules(this.createMapper());
        }
        return this.mapper;
    }

    private ObjectMapper registerAdditionalModules(ObjectMapper mapper) {
        for (Module module : this.additionalModules()) {
            mapper.registerModule(module);
        }
        return mapper;
    }

    protected ObjectMapper createReadMapper() {
        return this.mapper();
    }

    protected ObjectMapper createWriteMapper() {
        return this.mapper();
    }

    protected final <V> V load(ConfigKey<V> key) {
        if (!this.exists(key)) {
            return null;
        }
        try {
            return this.read(this.resolvePath(key), key.configClazz());
        }
        catch (ConfigurationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load configuration file.", e);
            this.backup(key);
            this.plugin.getLogger().log(Level.WARNING, "Recreating default config");
            this.write(this.resolvePath(key), key.initValue().get());
            return key.initValue().get();
        }
    }

    protected final <V> V createAndLoad(ConfigKey<V> key) {
        Path path = this.resolvePath(key);
        if (!this.exists(key)) {
            this.plugin.getLogger().info("Configuration file: " + path + " does not exist. Creating.");
            this.write(path, key.initValue().get());
        }
        return this.load(key);
    }

    protected ObjectMapper createMapper() {
        return this.configureDefault((MapperBuilder<?, ?>)YAMLMapper.builder());
    }

    public ObjectMapper configureDefault(MapperBuilder<?, ?> builder) {
        builder.addModule(this.getPlatformModule()).typeFactory(TypeFactory.defaultInstance().withClassLoader(this.plugin.getClass().getClassLoader())).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        if (builder instanceof YAMLMapper.Builder) {
            YAMLMapper.Builder yaml = (YAMLMapper.Builder)builder;
            yaml.disable(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.USE_NATIVE_TYPE_ID}).disable(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.WRITE_DOC_START_MARKER});
        }
        return builder.build().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
    }

    public final Module getPlatformModule() {
        if (this.plugin.getServer().getName().toLowerCase(Locale.ROOT).contains("spigot")) {
            return this.getBukkitModule();
        }
        return this.getPaperModule();
    }

    protected List<Module> additionalModules() {
        return Collections.emptyList();
    }

    protected JacksonPaper getPaperModule() {
        return ((JacksonPaperBuilder)JacksonPaper.builder().colorAsHex()).build();
    }

    protected JacksonBukkit getBukkitModule() {
        return ((JacksonBukkitBuilder)JacksonBukkit.builder().colorAsHex()).build();
    }

    private void backup(ConfigKey<?> key) {
        Path target = this.resolvePath(key);
        String backupName = "backup_" + DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm").format(LocalDateTime.now()) + "_" + target.getFileName();
        this.plugin.getLogger().log(Level.WARNING, "Backing up " + target + " to " + backupName);
        try {
            Files.move(target, target.getParent().resolve(backupName), new CopyOption[0]);
            this.plugin.getLogger().log(Level.SEVERE, "Backup done.");
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not create backup.");
        }
    }

    private void write(Path path, Object object) {
        try {
            if (object instanceof ConfigSubscriber) {
                ConfigSubscriber sub = (ConfigSubscriber)object;
                sub.preWrite(this);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)this.writer().writeValueAsString(object), new OpenOption[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not write configuration file to " + path, e);
            throw new ConfigurationException("Could not write configuration file to " + path, e);
        }
    }

    private <V> V read(Path path, Class<V> clazz) {
        try {
            Object v = this.reader().readValue(path.toFile(), clazz);
            if (v instanceof ConfigSubscriber) {
                ConfigSubscriber sub = (ConfigSubscriber)v;
                sub.postRead(this);
            }
            return (V)v;
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not read configuration file from " + path, e);
            throw new ConfigurationException("Could not read configuration file from " + path, e);
        }
    }

    private Path resolvePath(ConfigKey<?> key) {
        return key.path().isAbsolute() ? key.path() : this.plugin.getDataFolder().toPath().resolve(key.path());
    }

    @NotNull
    public EntryData[] getDebugInformations() {
        LinkedList<EntryData> configs = new LinkedList<EntryData>();
        for (ConfigKey<?> key : this.files.keySet()) {
            try {
                configs.add(new EntryData(key.toString(), this.writer().writeValueAsString(this.secondary(key))));
            }
            catch (JsonProcessingException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not dump config", e);
            }
        }
        return (EntryData[])configs.toArray(EntryData[]::new);
    }
}

