/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.serialization;

import de.eldoria.eldoutilities.serialization.SerializationUtil;
import de.eldoria.eldoutilities.serialization.TypeResolvingMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

public class SampleImplementation {

    @SerializableAs(value="SerializableClass")
    public class SerializableClass
    implements ConfigurationSerializable {
        private int someInt = 1;
        private String someString = "Hewo";
        private NestedClass nestedClass = new NestedClass();

        public SerializableClass() {
        }

        public SerializableClass(Map<String, Object> objectMap) {
            TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
            this.someInt = map.getValueOrDefault("someInt", this.someInt);
            this.someString = map.getValueOrDefault("someString", this.someString);
            this.nestedClass = map.getValueOrDefault("nestedClass", this.nestedClass);
        }

        @NotNull
        public Map<String, Object> serialize() {
            return SerializationUtil.newBuilder().add("someInt", this.someInt).add("someString", this.someString).add("nestedClass", this.nestedClass).build();
        }
    }

    @SerializableAs(value="NestedClass")
    public static class NestedClass
    implements ConfigurationSerializable {
        private String someString = "Amazing";
        private String someOtherString = "Much default";

        public NestedClass(Map<String, Object> objectMap) {
            TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
            this.someString = map.getValueOrDefault("someInt", this.someString);
            this.someOtherString = map.getValueOrDefault("someInt", this.someOtherString);
        }

        public NestedClass() {
        }

        @NotNull
        public Map<String, Object> serialize() {
            return SerializationUtil.newBuilder().add("someString", this.someString).add("someOtherString", this.someOtherString).build();
        }
    }
}

