/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.serialization.util;

import de.eldoria.eldoutilities.entities.EntityBuilder;
import de.eldoria.eldoutilities.serialization.SerializationUtil;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ArmorStandWrapper
implements ConfigurationSerializable {
    private String customName;
    private boolean customNameVisible;
    private double yaw;
    private double pitch;
    private Vector direction;
    private Vector headPose;
    private Vector bodyPose;
    private Vector leftArmPose;
    private Vector rightArmPose;
    private Vector leftLegPose;
    private Vector rightLegPose;
    private ItemStack helmet;
    private ItemStack chestPlate;
    private ItemStack leggins;
    private ItemStack itemInHand;
    private boolean arms;
    private boolean basePlate;
    private boolean marker;
    private boolean small;
    private boolean visible;

    public ArmorStandWrapper(Map<String, Object> objectMap) {
        SerializationUtil.mapOnObject(objectMap, this);
    }

    private ArmorStandWrapper(ArmorStand armorStand) {
        this.customName = armorStand.getCustomName();
        this.customNameVisible = armorStand.isCustomNameVisible();
        this.yaw = armorStand.getLocation().getYaw();
        this.pitch = armorStand.getLocation().getPitch();
        this.direction = armorStand.getLocation().getDirection();
        this.headPose = ArmorStandWrapper.eulerAngleToVector(armorStand.getHeadPose());
        this.bodyPose = ArmorStandWrapper.eulerAngleToVector(armorStand.getBodyPose());
        this.leftArmPose = ArmorStandWrapper.eulerAngleToVector(armorStand.getLeftArmPose());
        this.rightArmPose = ArmorStandWrapper.eulerAngleToVector(armorStand.getRightArmPose());
        this.leftLegPose = ArmorStandWrapper.eulerAngleToVector(armorStand.getLeftLegPose());
        this.rightLegPose = ArmorStandWrapper.eulerAngleToVector(armorStand.getRightLegPose());
        EntityEquipment equipment = armorStand.getEquipment();
        this.helmet = equipment.getHelmet();
        this.chestPlate = equipment.getChestplate();
        this.leggins = equipment.getLeggings();
        this.itemInHand = equipment.getItemInMainHand();
        this.arms = armorStand.hasArms();
        this.basePlate = armorStand.hasBasePlate();
        this.marker = armorStand.isMarker();
        this.small = armorStand.isSmall();
        this.visible = armorStand.isVisible();
    }

    public static ArmorStandWrapper serialize(ArmorStand armorStand) {
        return new ArmorStandWrapper(armorStand);
    }

    private static Vector eulerAngleToVector(EulerAngle euler) {
        return new Vector(euler.getX(), euler.getY(), euler.getZ());
    }

    private static EulerAngle vectorToEulerAngle(Vector vector) {
        return new EulerAngle(vector.getX(), vector.getY(), vector.getZ());
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.objectToMap(this);
    }

    public ArmorStand spawn(Location location) {
        return (ArmorStand)EntityBuilder.of((EntityType)EntityType.ARMOR_STAND, (Location)location).withCustomName(this.customName).withVisibleCustomName(this.customNameVisible).with(e -> {
            e.setRotation((float)this.yaw, (float)this.pitch);
            e.getLocation().setDirection(this.direction);
        }).with(ArmorStand.class, e -> {
            e.setHeadPose(ArmorStandWrapper.vectorToEulerAngle(this.headPose));
            e.setBodyPose(ArmorStandWrapper.vectorToEulerAngle(this.bodyPose));
            e.setLeftArmPose(ArmorStandWrapper.vectorToEulerAngle(this.leftArmPose));
            e.setRightArmPose(ArmorStandWrapper.vectorToEulerAngle(this.rightArmPose));
            e.setLeftLegPose(ArmorStandWrapper.vectorToEulerAngle(this.leftLegPose));
            e.setRightLegPose(ArmorStandWrapper.vectorToEulerAngle(this.rightLegPose));
        }).with(e -> {
            EntityEquipment eq = e.getEquipment();
            eq.setHelmet(this.helmet);
            eq.setChestplate(this.chestPlate);
            eq.setLeggings(this.leggins);
            eq.setItemInMainHand(this.itemInHand);
        }).with(ArmorStand.class, e -> {
            e.setArms(this.arms);
            e.setBasePlate(this.basePlate);
            e.setMarker(this.marker);
            e.setSmall(this.small);
            e.setVisible(this.visible);
        }).build();
    }
}

