/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.serialization.wrapper;

import de.eldoria.EldoUtilities;
import de.eldoria.eldoutilities.serialization.SerializationUtil;
import de.eldoria.eldoutilities.serialization.TypeResolvingMap;
import de.eldoria.eldoutilities.serialization.util.PluginSerializationName;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

@PluginSerializationName(value="{plugin}MapEntry")
public class MapEntry
implements ConfigurationSerializable {
    private String key;
    private Object object;

    public MapEntry(String key, Object object) {
        this.key = key;
        this.object = object;
    }

    public MapEntry(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        objectMap.forEach((k, v) -> EldoUtilities.logger().finer("Key: " + k + " | Value : " + v));
        this.key = (String)map.getValue("key");
        this.object = map.getValue("object");
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("key", this.key).add("object", this.object).build();
    }

    public String getKey() {
        return this.key;
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        return "MapEntry{key='" + this.key + "', object=" + this.object + "}";
    }
}

