/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.serialization.wrapper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class SerializeContainer {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(SerializeContainer.class, (Object)new SerializeContainerAdapter()).create();
    private final Map<String, Object> data;

    private SerializeContainer(Map<String, Object> data) {
        this.data = data;
    }

    public static SerializeContainer fromObject(ConfigurationSerializable obj) {
        return new SerializeContainer(obj.serialize());
    }

    public static SerializeContainer fromJson(String json) {
        return (SerializeContainer)GSON.fromJson(json, SerializeContainer.class);
    }

    public static String serializeToJson(ConfigurationSerializable obj) {
        return SerializeContainer.fromObject(obj).toJson();
    }

    public static <T extends ConfigurationSerializable> T deserializeFromJson(String json, Class<T> clazz) {
        return SerializeContainer.fromJson(json).toObject(clazz);
    }

    public <T extends ConfigurationSerializable> T toObject(Class<T> clazz) {
        return (T)ConfigurationSerialization.deserializeObject(this.data, clazz);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    private static class SerializeContainerAdapter
    implements JsonDeserializer<SerializeContainer> {
        private static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();

        private SerializeContainerAdapter() {
        }

        public SerializeContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            Map deserializedMap = (Map)context.deserialize(jsonObject.get("data"), MAP_TYPE);
            return new SerializeContainer(deserializedMap);
        }
    }
}

