/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.serialization.wrapper;

import de.eldoria.eldoutilities.serialization.SerializationUtil;
import de.eldoria.eldoutilities.serialization.TypeResolvingMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ShapedRecipeWrapper
implements ConfigurationSerializable {
    private final ItemStack result;
    private final String group;
    private final NamespacedKey key;
    private final List<String> shape;
    private final Map<Character, RecipeChoiceWrapper> choices;

    public ShapedRecipeWrapper(ShapedRecipe recipe) {
        this.result = recipe.getResult();
        this.group = recipe.getGroup();
        this.key = recipe.getKey();
        this.shape = Arrays.asList(recipe.getShape());
        this.choices = new HashMap<Character, RecipeChoiceWrapper>();
        for (Map.Entry entry : recipe.getChoiceMap().entrySet()) {
            this.choices.put((Character)entry.getKey(), RecipeChoiceWrapper.wrap((RecipeChoice)entry.getValue()));
        }
    }

    public ShapedRecipeWrapper(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        this.result = (ItemStack)map.getValue("result");
        this.group = (String)map.getValue("group");
        this.key = new NamespacedKey((String)map.getValue("namespace"), (String)map.getValue("key"));
        this.shape = (List)map.getValue("shape");
        this.choices = map.getMap("choices", (k, v) -> Character.valueOf(k.charAt(0)));
    }

    public ShapedRecipe getRecipe() {
        ShapedRecipe recipe = new ShapedRecipe(this.key, this.result);
        recipe.shape(this.shape.toArray(new String[0]));
        recipe.setGroup(this.group);
        for (Map.Entry<Character, RecipeChoiceWrapper> entry : this.choices.entrySet()) {
            recipe.setIngredient(entry.getKey().charValue(), entry.getValue().toChoice());
        }
        return recipe;
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("result", this.result).add("group", this.group).add("namespace", this.key.getNamespace()).add("key", this.key.getKey()).addMap("choices", this.choices, (k, v) -> k.toString()).build();
    }

    public static interface RecipeChoiceWrapper
    extends ConfigurationSerializable {
        public static RecipeChoiceWrapper wrap(RecipeChoice choice) {
            if (choice instanceof RecipeChoice.MaterialChoice) {
                return new MaterialChoiceWrapper((RecipeChoice.MaterialChoice)choice);
            }
            if (choice instanceof RecipeChoice.ExactChoice) {
                return new ExactChoiceWrapper((RecipeChoice.ExactChoice)choice);
            }
            throw new IllegalStateException("Unknown subclass " + choice.getClass().getName());
        }

        public RecipeChoice toChoice();

        public static class MaterialChoiceWrapper
        implements RecipeChoiceWrapper {
            List<Material> materials;

            public MaterialChoiceWrapper(RecipeChoice.MaterialChoice choice) {
                this.materials = choice.getChoices();
            }

            public MaterialChoiceWrapper(Map<String, Object> objectMap) {
                TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
                this.materials = map.getValueOrDefault("materials", Collections.emptyList(), Material.class);
            }

            @NotNull
            public Map<String, Object> serialize() {
                return SerializationUtil.newBuilder().build();
            }

            @Override
            public RecipeChoice toChoice() {
                return new RecipeChoice.MaterialChoice(this.materials);
            }
        }

        public static class ExactChoiceWrapper
        implements RecipeChoiceWrapper {
            List<ItemStack> choices;

            public ExactChoiceWrapper(RecipeChoice.ExactChoice choice) {
                this.choices = choice.getChoices();
            }

            public ExactChoiceWrapper(Map<String, Object> objectMap) {
                TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
                this.choices = (List)map.getValue("choices");
            }

            @Override
            public RecipeChoice toChoice() {
                return new RecipeChoice.ExactChoice(this.choices);
            }

            @NotNull
            public Map<String, Object> serialize() {
                return SerializationUtil.newBuilder().add("choices", this.choices).build();
            }
        }
    }
}

