/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.localization;

import de.eldoria.eldoutilities.localization.ILocalizer;
import de.eldoria.eldoutilities.localization.LocalizerBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Localizer
implements ILocalizer {
    private String defaultLanguage;
    private final Plugin plugin;
    private final String localesPath;
    private final String localesPrefix;
    private final Set<String> includedLocales;
    private final Pattern localePattern = Pattern.compile("_(([a-zA-Z]{2})(_[a-zA-Z]{2})?)\\.properties");
    private final Map<String, String> runtimeLocaleCodes = new HashMap<String, String>();
    private final Map<String, ResourceBundle> languages = new HashMap<String, ResourceBundle>();
    private final Function<Player, String> userLocale;
    private final List<ILocalizer> children = new ArrayList<ILocalizer>();
    private boolean checked;

    Localizer(Plugin plugin, String localesPath, String localesPrefix, String fallbackLocale, Function<Player, String> userLocale, Set<String> includedLocales) {
        this.plugin = plugin;
        this.localesPath = localesPath;
        this.localesPrefix = localesPrefix;
        this.userLocale = userLocale;
        this.includedLocales = includedLocales;
        this.defaultLanguage = fallbackLocale;
        this.createDefaults();
        this.bootstrap();
        this.loadLanguage(fallbackLocale);
        if (this.languages.containsKey(fallbackLocale)) {
            plugin.getLogger().log(Level.SEVERE, "Could not load default locale");
        }
        LOCALIZER.put(plugin.getClass(), this);
        for (String locale : includedLocales) {
            this.loadLanguage(locale);
        }
    }

    @Deprecated(forRemoval=true)
    public static ILocalizer create(Plugin plugin, String ... includedLocales) {
        return Localizer.create(plugin, "messages", "messages", Locale.US, includedLocales);
    }

    @Deprecated(forRemoval=true)
    public static ILocalizer create(Plugin plugin, String localesPath, String localesPrefix, Locale fallbackLocale, String ... includedLocales) {
        Localizer localizer = new LocalizerBuilder(plugin, fallbackLocale.toLanguageTag()).setLocalesPath(localesPath).setLocalesPrefix(localesPrefix).setUserLocale(e -> fallbackLocale.toLanguageTag()).setIncludedLocales(includedLocales).build();
        LOCALIZER.put(plugin.getClass(), localizer);
        return localizer;
    }

    public static LocalizerBuilder builder(Plugin plugin, String defaultLocale) {
        return new LocalizerBuilder(plugin, defaultLocale);
    }

    private void createDefaults() {
        this.runtimeLocaleCodes.put("error.invalidArguments", "Invalid arguments.\nSyntax: <gold><syntax><default>");
        this.runtimeLocaleCodes.put("error.invalidCommand", "Invalid Command");
        this.runtimeLocaleCodes.put("error.endOfRoute", "Please choose a subcommand. Available commands are:\n<gold><commands><default>");
        this.runtimeLocaleCodes.put("error.permission", "You do not have the permission to do this. (<gold><permission><default>)");
        this.runtimeLocaleCodes.put("error.invalidRange", "This value is out of range. Min: <gold><min><default> Max: <gold><max><default>");
        this.runtimeLocaleCodes.put("error.invalidEnumValue", "Invalid input value. Valid inputs are <gold><values><default>.");
        this.runtimeLocaleCodes.put("error.invalidMaterial", "Invalid material.");
        this.runtimeLocaleCodes.put("error.invalidNumber", "Invalid number");
        this.runtimeLocaleCodes.put("error.invalidBoolean", "Invalid value, <gold><true><default> or <gold><false><default>");
        this.runtimeLocaleCodes.put("error.invalidLength", "This input is too long. Max: <gold><max><default> chars.");
        this.runtimeLocaleCodes.put("error.notOnline", "Invalid player. This player is not online.");
        this.runtimeLocaleCodes.put("error.unknownPlayer", "Invalid player. This player has never played on this server.");
        this.runtimeLocaleCodes.put("error.unknownWorld", "Invalid world.");
        this.runtimeLocaleCodes.put("error.notAsConsole", "This command can not be executed from console.");
        this.runtimeLocaleCodes.put("error.onlyPlayer", "This command can only be used by players.");
        this.runtimeLocaleCodes.put("error.onlyConsole", "This command can only be used by console.");
        this.runtimeLocaleCodes.put("error.invalidSender", "This command can not be executed from here.");
        this.runtimeLocaleCodes.put("error.missingArgument", "Argument <INDEX> is accessed but not present.");
        this.runtimeLocaleCodes.put("error.notAsPlayer", "This command can not be executed as player");
        this.runtimeLocaleCodes.put("error.tooSmall", "The number is too small. Min: <gold><min>");
        this.runtimeLocaleCodes.put("error.tooLarge", "The number is too Large. Max: <gold><max>");
        this.runtimeLocaleCodes.put("commands.about", "<bold><gold><plugin_name></bold><default> by <bold><authors></bold>\nVersion: <bold><version></bold>\nSpigot: <bold><website></bold>\nSupport: <bold><discord></bold>");
        this.runtimeLocaleCodes.put("dialog.accept", "accept");
        this.runtimeLocaleCodes.put("dialog.deny", "deny");
        this.runtimeLocaleCodes.put("dialog.add", "add");
        this.runtimeLocaleCodes.put("dialog.remove", "remove");
        this.runtimeLocaleCodes.put("dialog.leftClickChange", "Left click to change");
        this.runtimeLocaleCodes.put("dialog.rightClickRemove", "Right click to remove");
    }

    public Plugin plugin() {
        return this.plugin;
    }

    @Deprecated(forRemoval=true)
    public void setLocale(String language) {
        this.bootstrap();
        this.setDefaultLocale(language);
    }

    public String getMessage(String key) {
        return this.getMessage(key, (CommandSender)null);
    }

    private void bootstrap() {
        if (!this.checked) {
            this.createOrUpdateLocaleFiles();
            this.checked = true;
        }
    }

    public void setDefaultLocale(String language) {
        this.bootstrap();
        if (!this.languages.containsKey(language)) {
            this.plugin.getLogger().log(Level.WARNING, "Language %s does not exist".formatted(language));
            return;
        }
        this.defaultLanguage = language;
    }

    public String getMessage(String key, @Nullable CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.getMessage(key, this.userLocale.apply(player));
        }
        return this.getMessage(key, this.defaultLanguage);
    }

    @Nullable
    public String getValue(String key) {
        return this.getValue(key, (CommandSender)null);
    }

    public String getMessage(String key, String language) {
        String result = this.getValue(key);
        if (result == null && LOCALIZATION_CODE.matcher(key).matches()) {
            this.plugin.getLogger().warning("Key " + key + " is missing in fallback file.");
            this.plugin.getLogger().log(Level.WARNING, "Message from", new RuntimeException());
            result = key;
        }
        return result;
    }

    @Nullable
    public String getValue(String key, CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.getValue(key, this.userLocale.apply(player));
        }
        return this.getValue(key, this.defaultLanguage);
    }

    @Nullable
    public String getValue(String key, String language) {
        String result;
        block7: {
            ILocalizer child;
            result = null;
            if (this.localeBundle(language).containsKey(key)) {
                try {
                    result = this.localeBundle(language).getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (result == null && this.localeBundle(this.defaultLanguage).containsKey(key)) {
                try {
                    result = this.localeBundle(this.defaultLanguage).getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (result != null) break block7;
            Iterator<ILocalizer> iterator = this.children.iterator();
            while (iterator.hasNext() && (result = (child = iterator.next()).getValue(key, language)) == null) {
            }
        }
        return result;
    }

    public ResourceBundle localeBundle(String language) {
        ResourceBundle resourceBundle = this.languages.get(language);
        if (resourceBundle == null) {
            this.plugin.getLogger().severe("Language %s not found".formatted(language));
            if (language.equals(this.defaultLanguage)) {
                throw new RuntimeException("Fallback language is not registered.");
            }
            return this.localeBundle(this.defaultLanguage);
        }
        return resourceBundle;
    }

    public ResourceBundle defaultBundle() {
        return this.localeBundle(this.defaultLanguage);
    }

    private void loadLanguage(String language) {
        try {
            this.languages.put(language, this.getBundle(this.getLocaleFile(language)));
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load language %s.".formatted(language), e);
        }
    }

    private Path getLocalePath() {
        return this.plugin.getDataFolder().toPath().resolve(this.localesPath);
    }

    private Path getLocaleFile(String locale) {
        return this.getLocalePath().resolve(this.getLocaleFileName(locale));
    }

    private String getLocaleFileName(String locale) {
        return String.format("%s_%s.properties", this.localesPrefix, locale);
    }

    private void createDefaultFiles() {
        for (String locale : this.includedLocales) {
            File localeFile = this.getLocaleFile(locale).toFile();
            if (localeFile.exists()) continue;
            try (InputStream resource = this.plugin.getResource(this.getLocaleFileName(locale));){
                if (resource == null) {
                    throw new FileNotFoundException("No locale file for " + locale + "found in resources.");
                }
                Files.copy(resource, this.getLocaleFile(locale), new CopyOption[0]);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create default message file for locale " + locale);
                continue;
            }
            this.plugin.getLogger().info("Created default locale " + this.getLocaleFileName(locale));
        }
    }

    private boolean isLocaleFile(Path path) {
        if (path.toFile().isDirectory()) {
            return false;
        }
        if (path.toFile().getName().matches(this.localesPrefix + "_[a-zA-Z]{2}(_[a-zA-Z]{2})?\\.properties")) {
            return true;
        }
        this.plugin.getLogger().info(path + " is not a valid message file. Skipped.");
        return false;
    }

    private ResourceBundle getDefaultLanguage() throws IOException {
        try (InputStream input = this.plugin.getResource(this.localesPrefix + ".properties");){
            if (input == null) {
                this.plugin.getLogger().severe("Could not load locale file " + this.localesPrefix + ".properties. Does it exist?");
                DummyResourceBundle dummyResourceBundle = new DummyResourceBundle();
                return dummyResourceBundle;
            }
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(input);
            return propertyResourceBundle;
        }
    }

    private ResourceBundle getBundle(String locale) throws IOException {
        try (InputStream input = this.plugin.getResource(this.getLocaleFileName(locale));){
            if (input == null) {
                this.plugin.getLogger().severe("Could not load locale file " + this.getLocaleFileName(locale) + ".properties. Does it exist?");
                ResourceBundle resourceBundle = this.getDefaultLanguage();
                return resourceBundle;
            }
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(input);
            return propertyResourceBundle;
        }
    }

    private ResourceBundle getBundle(Locale locale) throws IOException {
        if (locale == null) {
            return this.getDefaultLanguage();
        }
        return this.getBundle(locale.toString());
    }

    private ResourceBundle getBundle(Path locale) throws IOException {
        try (InputStream input = Files.newInputStream(locale, new OpenOption[0]);){
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(input);
            return propertyResourceBundle;
        }
    }

    private Map<String, String> bundleMap(Path path) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>(String::compareToIgnoreCase);
        Files.readAllLines(path, StandardCharsets.UTF_8).stream().map(line -> line.split("=", 2)).filter(line -> ((String[])line).length == 2).forEach(line -> map.put(line[0], line[1]));
        return map;
    }

    private Set<String> getDefaultKeys() throws IOException {
        HashSet<String> defaultKeys = new HashSet<String>(Collections.list(this.getDefaultLanguage().getKeys()));
        defaultKeys.addAll(this.runtimeLocaleCodes.keySet());
        return defaultKeys;
    }

    private String timestamp() {
        return DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").format(LocalDateTime.now());
    }

    private void createOrUpdateLocaleFiles() {
        try {
            Files.createDirectories(this.getLocalePath(), new FileAttribute[0]);
        }
        catch (IOException e2) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not create message directory.", e2);
        }
        this.createDefaultFiles();
        ArrayList localeFiles = new ArrayList();
        try (Stream<Path> files = Files.list(this.getLocalePath());){
            files.filter(this::isLocaleFile).forEach(localeFiles::add);
        }
        catch (IOException e3) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load message files.");
        }
        for (Path path : localeFiles) {
            Map<String, String> bundleMap;
            ResourceBundle refBundle;
            Set<String> updateKeys;
            try {
                updateKeys = this.getDefaultKeys();
            }
            catch (IOException e4) {
                this.plugin.getLogger().log(Level.WARNING, "Could not load reference file... Aborting update!", e4);
                return;
            }
            try {
                refBundle = this.getBundle(this.extractLocale(path));
            }
            catch (IOException e5) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not load any reference locale", e5);
                continue;
            }
            try {
                bundleMap = this.bundleMap(path);
            }
            catch (IOException e6) {
                this.plugin.getLogger().log(Level.WARNING, "Could not update locale " + path + ".", e6);
                continue;
            }
            updateKeys.removeAll(bundleMap.keySet());
            if (updateKeys.isEmpty()) {
                this.plugin.getLogger().info("Locale " + path + " is up to date.");
                continue;
            }
            this.plugin.getLogger().info("Updating " + path + ".");
            for (String currKey : updateKeys) {
                String value = refBundle.containsKey(currKey) ? refBundle.getString(currKey) : this.runtimeLocaleCodes.getOrDefault(currKey, "");
                bundleMap.put(currKey, value);
                this.plugin.getLogger().info("Added: " + currKey + "=" + value.replace("\n", "\\n"));
            }
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            lines.add((CallSite)((Object)("# File automatically updated at " + this.timestamp())));
            bundleMap.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), ((String)e.getValue()).replace("\n", "\\n"))).forEach(lines::add);
            try {
                Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e7) {
                this.plugin.getLogger().log(Level.WARNING, "Could not update locale " + path + ".", e7);
                continue;
            }
            this.plugin.getLogger().info("Updated locale " + path + ". Please check your translation.");
        }
    }

    private Locale extractLocale(Path filename) {
        Matcher matcher = this.localePattern.matcher(filename.toFile().getName());
        if (matcher.find()) {
            String group = matcher.group(1);
            String[] part = group.split("_");
            if (part.length == 1) {
                return new Locale(part[0]);
            }
            return new Locale(part[0], part[1]);
        }
        return null;
    }

    public String localize(String message) {
        if (message == null) {
            return null;
        }
        if (ILocalizer.isLocaleCode((String)message)) {
            message = this.getMessage(message);
        }
        return message;
    }

    public String localize(CommandSender sender, String message) {
        if (message == null) {
            return null;
        }
        if (ILocalizer.isLocaleCode((String)message)) {
            message = this.getMessage(message, sender);
        }
        return message;
    }

    @Deprecated(forRemoval=true)
    public String[] getIncludedLocales() {
        return this.includedLocales.toArray(new String[0]);
    }

    public Set<String> includedLocales() {
        return Collections.unmodifiableSet(this.includedLocales);
    }

    public void addLocaleCodes(Map<String, String> runtimeLocaleCodes) {
        this.runtimeLocaleCodes.putAll(runtimeLocaleCodes);
    }

    public void registerChild(ILocalizer localizer) {
        this.plugin.getLogger().info("Localizer from " + localizer.plugin().getName() + " registered as child.");
        this.children.add(localizer);
    }

    private static class DummyResourceBundle
    extends ResourceBundle {
        private DummyResourceBundle() {
        }

        @Override
        protected Object handleGetObject(@NotNull String key) {
            return null;
        }

        @Override
        @NotNull
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }
    }
}

