/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.localization;

import de.eldoria.eldoutilities.localization.ILocalizer;
import de.eldoria.eldoutilities.localization.IMessageComposer;
import de.eldoria.eldoutilities.utils.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.intellij.lang.annotations.Language;

public class MessageComposer
implements IMessageComposer {
    private final StringBuilder stringBuilder = new StringBuilder();
    private final List<TagResolver> replacements = new ArrayList<TagResolver>();

    private MessageComposer() {
    }

    public static MessageComposer create() {
        return new MessageComposer();
    }

    public static String escape(String text) {
        return ILocalizer.escape((String)text);
    }

    public MessageComposer localeCode(@Language(value="properties") String propertyKey, TagResolver ... replacements) {
        this.stringBuilder.append(ILocalizer.escape((String)propertyKey));
        this.replacements.addAll(Arrays.asList(replacements));
        return this;
    }

    public MessageComposer tag(String text) {
        return this.text("<%s>", text);
    }

    public MessageComposer text(String text, Object ... objects) {
        this.stringBuilder.append(String.format(text, objects));
        return this;
    }

    public MessageComposer text(Object object) {
        this.stringBuilder.append(object.toString());
        return this;
    }

    public MessageComposer text(Collection<String> messages) {
        return this.text(messages, "\n");
    }

    public MessageComposer text(Collection<String> messages, String delimiter) {
        this.stringBuilder.append(String.join((CharSequence)delimiter, messages));
        return this;
    }

    public MessageComposer space() {
        this.stringBuilder.append(" ");
        return this;
    }

    public MessageComposer space(int spaces) {
        this.stringBuilder.append(" ".repeat(spaces));
        return this;
    }

    public MessageComposer fillLines() {
        return this.fillLines(25);
    }

    public MessageComposer fillLines(int lines) {
        int lineCount = TextUtil.countChars((String)this.stringBuilder.toString(), (char)'\n') + 1;
        this.prependLines(Math.max(lines - lineCount, 0));
        return this;
    }

    public MessageComposer prependLines(int lines) {
        this.stringBuilder.insert(0, "\n".repeat(lines));
        return this;
    }

    public MessageComposer prependLines() {
        this.prependLines(25);
        return this;
    }

    public MessageComposer newLine() {
        this.stringBuilder.append("\n");
        return this;
    }

    public String build() {
        return this.stringBuilder.toString();
    }

    public List<TagResolver> replacements() {
        return Collections.unmodifiableList(this.replacements);
    }

    public String buildLocalized(ILocalizer localizer) {
        return localizer.localize(this.stringBuilder.toString());
    }
}

