/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.messages;

import de.eldoria.eldoutilities.localization.ILocalizer;
import de.eldoria.eldoutilities.localization.IMessageComposer;
import de.eldoria.eldoutilities.messages.MessageSenderBuilder;
import de.eldoria.eldoutilities.messages.conversion.MiniMessageConversion;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MessageSender {
    private static final Map<Class<? extends Plugin>, MessageSender> PLUGIN_SENDER = new HashMap<Class<? extends Plugin>, MessageSender>();
    @Nullable
    private final Class<? extends Plugin> ownerPlugin;
    private final Plugin plugin;
    private MiniMessage miniMessage;
    private TagResolver messageTagResolver;
    private TagResolver errorTagResolver;
    private Component prefix;

    public MessageSender(Plugin plugin, MiniMessage miniMessage, TagResolver messageTagResolver, TagResolver errorTagResolver, Component prefix) {
        this.ownerPlugin = plugin.getClass();
        this.plugin = plugin;
        this.miniMessage = miniMessage;
        this.messageTagResolver = messageTagResolver;
        this.errorTagResolver = errorTagResolver;
        this.prefix = prefix;
    }

    public static void register(MessageSender messageSender) {
        if (messageSender.ownerPlugin == null) {
            return;
        }
        PLUGIN_SENDER.put(messageSender.ownerPlugin, messageSender);
    }

    public static MessageSender getPluginMessageSender(@NotNull Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin can not be null");
        }
        return MessageSender.getPluginMessageSender(plugin.getClass());
    }

    public static MessageSenderBuilder builder(Plugin plugin) {
        return new MessageSenderBuilder(plugin);
    }

    public static MessageSender getPluginMessageSender(@NotNull Class<? extends Plugin> plugin) {
        if (!PLUGIN_SENDER.containsKey(plugin)) {
            throw new IllegalStateException("No message sender was created for " + plugin.getName());
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin can not be null");
        }
        return PLUGIN_SENDER.get(plugin);
    }

    private MessageSender update(MiniMessage miniMessage, TagResolver messageTagResolver, TagResolver errorTagResolver, Component prefix) {
        this.miniMessage = miniMessage;
        this.messageTagResolver = messageTagResolver;
        this.errorTagResolver = errorTagResolver;
        this.prefix = prefix;
        return this;
    }

    public void sendMessage(CommandSender sender, String message, TagResolver ... placeholder) {
        this.sendMessage(sender, this.serialize(sender, message, this.messageTagResolver, placeholder));
    }

    public void sendMessage(CommandSender sender, IMessageComposer composer) {
        this.sendMessage(sender, this.serialize(sender, composer.build(), this.messageTagResolver, composer.replacements().toArray(new TagResolver[0])));
    }

    public void sendError(CommandSender sender, String message, TagResolver ... placeholder) {
        this.sendMessage(sender, this.serialize(sender, message, this.errorTagResolver, placeholder));
    }

    public void sendError(CommandSender sender, IMessageComposer composer) {
        this.sendMessage(sender, this.serialize(sender, composer.build(), this.errorTagResolver, composer.replacements().toArray(new TagResolver[0])));
    }

    public abstract void sendMessage(CommandSender var1, Component var2);

    public abstract void broadcast(String var1);

    public void sendTitle(Player player, String title, String subtitle, Title.Times times, TagResolver ... placeholder) {
        this.sendTitle(player, Title.title((Component)this.serialize((CommandSender)player, title, this.messageTagResolver, placeholder), (Component)this.serialize((CommandSender)player, subtitle, this.messageTagResolver, placeholder), (Title.Times)times));
    }

    public abstract void sendTitle(Player var1, Title var2);

    public abstract void sendActionBar(Player var1, String var2, TagResolver ... var3);

    public abstract void sendErrorActionBar(Player var1, String var2, TagResolver ... var3);

    public abstract void sendBossBar(Player var1, BossBar var2);

    public abstract BossBar sendBossBar(Player var1, String var2, float var3, BossBar.Color var4, BossBar.Overlay var5, Set<BossBar.Flag> var6);

    public abstract void hideBossBar(Player var1, BossBar var2);

    private ILocalizer loc() {
        return ILocalizer.getPluginLocalizer(this.ownerPlugin);
    }

    protected Component serialize(CommandSender sender, String message, TagResolver resolver, TagResolver ... placeholder) {
        String converted = MiniMessageConversion.convertLegacyColorCodes((String)message);
        if (!converted.equals(message)) {
            this.plugin.getLogger().warning("Found legacy color codes in message.");
            this.plugin.getLogger().warning((String)message);
            message = converted;
        }
        if (ILocalizer.isLocaleCode((String)message)) {
            message = ILocalizer.escape((String)message);
        }
        message = "<default>" + (String)message;
        TagResolver[] finalResolver = new TagResolver[]{resolver};
        if (placeholder.length > 0) {
            TagResolver[] tags = Arrays.copyOf(placeholder, placeholder.length + 1);
            tags[tags.length - 1] = resolver;
            finalResolver = tags;
        }
        return this.resolveTags((String)message, this.addI18nTag(sender, TagResolver.resolver((TagResolver[])finalResolver)));
    }

    private Component resolveTags(String message, TagResolver ... resolver) {
        Component component = this.miniMessage.deserialize(message, resolver);
        String newMessage = (String)this.miniMessage.serialize(component);
        if (newMessage.equals(message)) {
            return component;
        }
        return this.resolveTags(newMessage, resolver);
    }

    public Component prefix() {
        return this.prefix;
    }

    protected Component applyPrefix(Component component) {
        return this.prefix.appendSpace().append(component);
    }

    public String translatePlain(String message, TagResolver ... replacements) {
        return this.translatePlain(null, message, replacements);
    }

    public String translatePlain(@Nullable CommandSender sender, String message, TagResolver ... replacements) {
        return PlainTextComponentSerializer.plainText().serialize(this.serialize(sender, message, this.messageTagResolver, replacements));
    }

    public Component serializeMessage(String message, TagResolver ... placeholder) {
        return this.serializeMessage(null, message, placeholder);
    }

    public Component serializeMessage(@Nullable CommandSender sender, String message, TagResolver ... placeholder) {
        return this.serialize(sender, message, this.messageTagResolver, placeholder);
    }

    public Component serializeError(String message, TagResolver ... placeholder) {
        return this.serializeError(null, message, placeholder);
    }

    public Component serializeError(@Nullable CommandSender sender, String message, TagResolver ... placeholder) {
        return this.serialize(sender, message, this.errorTagResolver, placeholder);
    }

    public MiniMessage miniMessage() {
        return this.miniMessage;
    }

    private TagResolver addI18nTag(CommandSender sender, TagResolver resolvers) {
        if (this.loc() != ILocalizer.DEFAULT) {
            return TagResolver.resolver((TagResolver[])new TagResolver[]{resolvers, TagResolver.builder().tag("i18n", (argumentQueue, context) -> this.localizeTag(sender, (ArgumentQueue)argumentQueue, (Context)context)).build()});
        }
        return resolvers;
    }

    private Tag localizeTag(CommandSender sender, ArgumentQueue args, Context ctx) {
        return Tag.selfClosingInserting((Component)ctx.deserialize(this.loc().localize(sender, args.popOr("locale tag required").value())));
    }

    public boolean isAnonymous() {
        return this.ownerPlugin == null;
    }

    protected TagResolver messageTagResolver() {
        return this.messageTagResolver;
    }

    protected TagResolver errorTagResolver() {
        return this.errorTagResolver;
    }

    protected Plugin plugin() {
        return this.plugin;
    }

    public abstract Audience asAudience(Player var1);
}

