/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.messages;

import de.eldoria.eldoutilities.localization.ILocalizer;
import de.eldoria.eldoutilities.messages.MessageSender;
import de.eldoria.eldoutilities.messages.impl.PaperMessageSender;
import de.eldoria.eldoutilities.messages.impl.SpigotMessageSender;
import de.eldoria.eldoutilities.utils.ReflectionUtil;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageSenderBuilder {
    private final MiniMessage.Builder miniMessage = MiniMessage.builder();
    private final TagResolver.Builder messageTagResolver = TagResolver.builder().tag("default", Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{NamedTextColor.GREEN}));
    private final TagResolver.Builder errorTagResolver = TagResolver.builder().tag("default", Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{NamedTextColor.RED}));
    private final TagResolver.Builder defaultTagResolver = TagResolver.builder();
    @Nullable
    private final Plugin plugin;
    private Component prefix = Component.empty();
    private ILocalizer localizer = ILocalizer.DEFAULT;
    private UnaryOperator<String> preProcessor = s -> s;

    public MessageSenderBuilder(@Nullable Plugin plugin) {
        this.plugin = plugin;
    }

    public MessageSenderBuilder localizer(ILocalizer localizer) {
        this.localizer = localizer;
        return this;
    }

    public MessageSenderBuilder prefix(Component prefix) {
        this.prefix = prefix;
        this.defaultTagResolver.tag("prefix", Tag.selfClosingInserting((Component)this.prefix));
        return this;
    }

    public MessageSenderBuilder prefix(String prefix) {
        return this.prefix(MiniMessage.miniMessage().deserialize((Object)prefix));
    }

    public MessageSenderBuilder messageColor(TextColor color) {
        this.messageTagResolver.tag("default", Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{color}));
        return this;
    }

    public MessageSenderBuilder errorColor(TextColor color) {
        this.errorTagResolver.tag("default", Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{color}));
        return this;
    }

    public MessageSenderBuilder addTag(Consumer<TagResolver.Builder> consumer) {
        consumer.accept(this.defaultTagResolver);
        return this;
    }

    public MessageSenderBuilder addMessageTag(Consumer<TagResolver.Builder> consumer) {
        consumer.accept(this.messageTagResolver);
        return this;
    }

    public MessageSenderBuilder addErrorTag(Consumer<TagResolver.Builder> consumer) {
        consumer.accept(this.errorTagResolver);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull MiniMessage.Builder strict(boolean strict) {
        return this.miniMessage.strict(strict);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull MiniMessage.Builder debug(@Nullable Consumer<String> debugOutput) {
        return this.miniMessage.debug(debugOutput);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull MiniMessage.Builder postProcessor(@NotNull UnaryOperator<Component> postProcessor) {
        return this.miniMessage.postProcessor(postProcessor);
    }

    public MessageSenderBuilder preProcessor(@NotNull UnaryOperator<String> preProcessor) {
        this.preProcessor = preProcessor;
        return this;
    }

    public MessageSender register() {
        TagResolver defaultResolver = this.defaultTagResolver.resolver(StandardTags.defaults()).build();
        MessageSender messageSender = !ReflectionUtil.isPaper() ? new SpigotMessageSender(this.plugin, this.miniMessage.tags(defaultResolver).preProcessor(in -> (String)this.preProcessor.apply(this.localizer.localize(in))).build(), TagResolver.resolver((TagResolver[])new TagResolver[]{defaultResolver, this.messageTagResolver.build()}), TagResolver.resolver((TagResolver[])new TagResolver[]{defaultResolver, this.errorTagResolver.build()}), this.prefix) : new PaperMessageSender(this.plugin, this.miniMessage.tags(defaultResolver).preProcessor(in -> (String)this.preProcessor.apply(this.localizer.localize(in))).build(), TagResolver.resolver((TagResolver[])new TagResolver[]{defaultResolver, this.messageTagResolver.build()}), TagResolver.resolver((TagResolver[])new TagResolver[]{defaultResolver, this.errorTagResolver.build()}), this.prefix);
        MessageSender.register(messageSender);
        return messageSender;
    }
}

