/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.messages;

import java.util.Locale;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.entity.Player;

public final class Replacement {
    private Replacement() {
        throw new UnsupportedOperationException("This is a utility class.");
    }

    public static TagResolver create(String key, String value) {
        return Placeholder.parsed((String)Replacement.sanitizeKey(key), (String)value);
    }

    public static TagResolver replacement(String key, String value) {
        return Replacement.create(key, value);
    }

    public static TagResolver create(String key, Object value) {
        return Placeholder.parsed((String)Replacement.sanitizeKey(key), (String)String.valueOf(value));
    }

    public static TagResolver replacement(String key, Object value) {
        return Replacement.create(key, value);
    }

    public static TagResolver create(String key, Double value) {
        return Replacement.create(key, String.format("%.2f", value));
    }

    public static TagResolver create(String key, Float value) {
        return Replacement.create(key, String.format("%.2f", value));
    }

    public static TagResolver number(String key, Double value) {
        return Replacement.create(key, value);
    }

    public static TagResolver number(String key, Float value) {
        return Replacement.create(key, value);
    }

    public static TagResolver create(String key, Enum<?> anEnum) {
        return Replacement.create(key, anEnum.name());
    }

    public static TagResolver name(String key, Enum<?> anEnum) {
        return Replacement.create(key, anEnum);
    }

    public static TagResolver create(String key, Player player) {
        return Replacement.create(key, player.getName());
    }

    public static TagResolver player(String key, Player player) {
        return Replacement.create(key, player);
    }

    public static TagResolver create(String key, World world) {
        return Replacement.create(key, world.getName());
    }

    public static TagResolver world(String key, World world) {
        return Replacement.create(key, world);
    }

    private static String sanitizeKey(String key) {
        return key.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
    }
}

