/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.messages.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MiniMessageConversion {
    private static final List<Replacement> CODES = new ArrayList<Replacement>();
    private static final Pattern LEGACY_CODE = Pattern.compile("[\u00a7&][a-f0-9klmnor]");

    public static String convertLegacyColorCodes(String message) {
        if (!LEGACY_CODE.matcher(message).find()) {
            return message;
        }
        for (Replacement entry : CODES) {
            message = entry.apply(message);
        }
        return message;
    }

    static {
        CODES.add(Replacement.create("0", "black"));
        CODES.add(Replacement.create("1", "dark_blue"));
        CODES.add(Replacement.create("2", "dark_green"));
        CODES.add(Replacement.create("3", "dark_aqua"));
        CODES.add(Replacement.create("4", "dark_red"));
        CODES.add(Replacement.create("5", "dark_purple"));
        CODES.add(Replacement.create("6", "gold"));
        CODES.add(Replacement.create("7", "gray"));
        CODES.add(Replacement.create("8", "dark_gray"));
        CODES.add(Replacement.create("9", "blue"));
        CODES.add(Replacement.create("a", "green"));
        CODES.add(Replacement.create("b", "aqua"));
        CODES.add(Replacement.create("c", "red"));
        CODES.add(Replacement.create("d", "light_purple"));
        CODES.add(Replacement.create("e", "yellow"));
        CODES.add(Replacement.create("f", "white"));
        CODES.add(Replacement.create("k", "obf"));
        CODES.add(Replacement.create("l", "b"));
        CODES.add(Replacement.create("m", "st"));
        CODES.add(Replacement.create("n", "u"));
        CODES.add(Replacement.create("o", "i"));
        CODES.add(Replacement.create("r", "reset"));
    }

    record Replacement(Pattern pattern, String tag) {
        public static Replacement create(String code, String tag) {
            return new Replacement(Pattern.compile("[\u00a7&]" + code), "<%s>".formatted(tag));
        }

        public String apply(String message) {
            return this.pattern.matcher(message).replaceAll(this.tag);
        }
    }
}

