/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.updater.lynaupdater;

import de.eldoria.eldoutilities.debug.DefaultProperties;
import de.eldoria.eldoutilities.debug.UserData;
import de.eldoria.eldoutilities.updater.UpdateData;
import de.eldoria.eldoutilities.updater.lynaupdater.LynaUpdateDataBuilder;
import de.eldoria.eldoutilities.updater.lynaupdater.LynaUpdateResponse;
import de.eldoria.eldoutilities.utils.Durations;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class LynaUpdateData
extends UpdateData<LynaUpdateResponse> {
    public static final String HOST = "https://lyna.eldoria.de";
    private static final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm").withZone(ZoneId.of("Z"));
    private final int productId;
    private final String host;
    private final UserData userData;

    LynaUpdateData(Plugin plugin, String notifyPermission, boolean notifyUpdate, int productId, String host, String updateUrl, String updateMessage) {
        super(plugin, notifyPermission, notifyUpdate, false, updateUrl, updateMessage);
        this.productId = productId;
        this.host = host;
        this.userData = UserData.get((Plugin)plugin);
    }

    public static LynaUpdateDataBuilder builder(Plugin plugin, int productId) {
        return new LynaUpdateDataBuilder(plugin, productId);
    }

    @Override
    protected Map<String, Object> replacements(LynaUpdateResponse updateResponse) {
        Map<String, Object> replacements = super.replacements(updateResponse);
        replacements.put("new_time", updateResponse.publishedDuration());
        this.userData.property(DefaultProperties.UNIX).map(Long::parseLong).map(Instant::ofEpochSecond).map(instant -> Duration.between(instant, Instant.now())).map(Durations::simpleDurationFormat).ifPresent(time -> replacements.put("current_time", time));
        this.userData.property(DefaultProperties.UNIX).map(Long::parseLong).map(Instant::ofEpochSecond).map(format::format).ifPresent(time -> replacements.put("current_date_time", time));
        replacements.put("new_date_time", format.format(Instant.ofEpochSecond(updateResponse.published())));
        return replacements;
    }

    public int productId() {
        return this.productId;
    }

    public String host() {
        return this.host;
    }

    public UserData userData() {
        return this.userData;
    }
}

