/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.eldoutilities.updater.spigotupdater;

import de.eldoria.eldoutilities.updater.DefaultUpdateResponse;
import de.eldoria.eldoutilities.updater.Updater;
import de.eldoria.eldoutilities.updater.spigotupdater.SpigotUpdateData;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;

public final class SpigotUpdateChecker
extends Updater<DefaultUpdateResponse, SpigotUpdateData> {
    public SpigotUpdateChecker(SpigotUpdateData data) {
        super(data);
    }

    @Override
    protected Optional<DefaultUpdateResponse> checkUpdate(SpigotUpdateData data) {
        HttpRequest get = HttpRequest.newBuilder().uri(URI.create("https://api.spigotmc.org/legacy/update.php?resource=" + data.getSpigotId())).GET().build();
        try {
            HttpResponse<String> response = this.client().send(get, HttpResponse.BodyHandlers.ofString());
            return Optional.of(DefaultUpdateResponse.create(response.body(), data.plugin()));
        }
        catch (IOException | InterruptedException e) {
            return Optional.empty();
        }
    }
}

