/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.google.common.io.Files;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.asciidoctor.asciidoclet.DocletOptions;
import org.asciidoctor.asciidoclet.DocletRenderer;

public class DocletIterator {
    private static final Pattern ASCIIDOC_FILE_PATTERN = Pattern.compile("(.*\\.(ad|adoc|txt|asciidoc))");
    private final DocletOptions docletOptions;

    public DocletIterator(DocletOptions docletOptions) {
        this.docletOptions = docletOptions;
    }

    public boolean render(RootDoc rootDoc, DocletRenderer renderer) {
        if (!this.processOverview(rootDoc, renderer)) {
            return false;
        }
        ClassDoc[] specifiedClasses = rootDoc.specifiedClasses();
        PackageDoc[] specifiedPackages = rootDoc.specifiedPackages();
        HashSet<PackageDoc> packages = new HashSet<PackageDoc>();
        if (specifiedClasses != null && specifiedClasses.length > 0) {
            for (ClassDoc classDoc : specifiedClasses) {
                packages.add(classDoc.containingPackage());
                this.renderClass(classDoc, renderer);
            }
        } else {
            for (ClassDoc classDoc : rootDoc.classes()) {
                packages.add(classDoc.containingPackage());
                this.renderClass(classDoc, renderer);
            }
        }
        if (specifiedPackages != null && specifiedPackages.length > 0) {
            for (PackageDoc packageDoc : specifiedPackages) {
                renderer.renderDoc((Doc)packageDoc);
            }
        } else {
            for (PackageDoc doc : packages) {
                renderer.renderDoc((Doc)doc);
            }
        }
        return true;
    }

    private void renderClass(ClassDoc doc, DocletRenderer renderer) {
        renderer.renderDoc((Doc)doc);
        for (FieldDoc fieldDoc : doc.fields()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.constructors()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.methods()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.enumConstants()) {
            renderer.renderDoc((Doc)fieldDoc);
        }
        if (doc instanceof AnnotationTypeDoc) {
            for (FieldDoc fieldDoc : ((AnnotationTypeDoc)doc).elements()) {
                renderer.renderDoc((Doc)fieldDoc);
            }
        }
    }

    private boolean processOverview(RootDoc rootDoc, DocletRenderer renderer) {
        Optional<File> overview = this.docletOptions.overview();
        if (overview.isPresent()) {
            File overviewFile = (File)overview.get();
            if (DocletIterator.isAsciidocFile(overviewFile.getName())) {
                try {
                    String overviewContent = Files.asCharSource((File)overviewFile, (Charset)this.docletOptions.encoding()).read();
                    rootDoc.setRawCommentText(overviewContent);
                    renderer.renderDoc((Doc)rootDoc);
                }
                catch (IOException e) {
                    rootDoc.printError("Error reading overview file: " + e.getLocalizedMessage());
                    return false;
                }
            } else {
                rootDoc.printNotice("Skipping non-AsciiDoc overview " + overviewFile + ", will be processed by standard Doclet.");
            }
        }
        return true;
    }

    private static boolean isAsciidocFile(String name) {
        return ASCIIDOC_FILE_PATTERN.matcher(name).matches();
    }
}

