/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.asciidoclet;

import com.google.common.base.Optional;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.sun.javadoc.DocErrorReporter;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class OutputTemplates {
    private static final String[] TEMPLATE_NAMES = new String[]{"section.html.haml", "paragraph.html.haml"};
    private final File templateDir;

    private OutputTemplates(File templateDir) {
        this.templateDir = templateDir;
    }

    static Optional<OutputTemplates> create(DocErrorReporter errorReporter) {
        File dir = OutputTemplates.prepareTemplateDir(errorReporter);
        return dir == null ? Optional.absent() : Optional.of((Object)new OutputTemplates(dir));
    }

    File templateDir() {
        return this.templateDir;
    }

    void delete() {
        for (String templateName : TEMPLATE_NAMES) {
            new File(this.templateDir, templateName).delete();
        }
        this.templateDir.delete();
    }

    private static File prepareTemplateDir(DocErrorReporter errorReporter) {
        File templateDir = Files.createTempDir();
        try {
            for (String templateName : TEMPLATE_NAMES) {
                OutputTemplates.prepareTemplate(templateDir, templateName);
            }
            return templateDir;
        }
        catch (IOException e) {
            errorReporter.printWarning("Failed to prepare templates: " + e.getLocalizedMessage());
            return null;
        }
    }

    private static void prepareTemplate(File templateDir, String template) throws IOException {
        URL src = OutputTemplates.class.getClassLoader().getResource("templates/" + template);
        if (src == null) {
            throw new IOException("Could not find template " + template);
        }
        ByteSink dest = Files.asByteSink((File)new File(templateDir, template), (FileWriteMode[])new FileWriteMode[0]);
        Resources.asByteSource((URL)src).copyTo(dest);
    }
}

