/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.maven.plugin.plantuml.generator;

import de.elnarion.util.plantuml.generator.PlantUMLClassDiagramGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class PlantUMLGeneratorMojo
extends AbstractMojo {
    static final String PREFIX = "plantuml-generator.";
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="plantuml-generator.outputDirectory", defaultValue="${project.build.directory}/generated-docs", required=false)
    private File outputDirectory;
    @Parameter(property="plantuml-generator.outputFilename", required=true)
    private String outputFilename;
    @Parameter(property="plantuml-generator.hideFields", defaultValue="false", required=false)
    private boolean hideFields;
    @Parameter(property="plantuml-generator.hideMethodsDirectory", defaultValue="false", required=false)
    private boolean hideMethods;
    @Parameter(property="plantuml-generator.scanPackages", defaultValue="", required=true)
    private List<String> scanPackages;
    @Parameter(property="plantuml-generator.hideClasses", defaultValue="", required=false)
    private List<String> hideClasses;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor descriptor;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting plantuml generation ");
        try {
            ClassLoader loader = this.getCompileClassLoader();
            PlantUMLClassDiagramGenerator classDiagramGenerator = new PlantUMLClassDiagramGenerator(loader, this.scanPackages, this.hideClasses, this.hideFields, this.hideMethods);
            String classDiagramText = classDiagramGenerator.generateDiagramText();
            this.getLog().debug((CharSequence)"diagram text:");
            this.getLog().debug((CharSequence)classDiagramText);
            this.getLog().info((CharSequence)"Diagram generated.");
            File outputFile = new File(this.outputDirectory.getAbsolutePath() + File.separator + this.outputFilename);
            if (!outputFile.exists()) {
                outputFile.getParentFile().mkdirs();
                boolean created = outputFile.createNewFile();
                if (!created) {
                    this.getLog().error((CharSequence)("Output file " + outputFile.getAbsolutePath() + " could not be created."));
                    return;
                }
            }
            IOUtils.write((String)classDiagramText, (OutputStream)new FileOutputStream(outputFile), (String)this.encoding);
            this.getLog().info((CharSequence)("Diagram written to " + outputFile.getAbsolutePath()));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Exception:" + e.getMessage()));
            this.getLog().error((Throwable)e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public boolean isHideFields() {
        return this.hideFields;
    }

    public void setHideFields(boolean hideFields) {
        this.hideFields = hideFields;
    }

    public boolean isHideMethods() {
        return this.hideMethods;
    }

    public void setHideMethods(boolean hideMethods) {
        this.hideMethods = hideMethods;
    }

    public List<String> getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(List<String> scanPackages) {
        this.scanPackages = scanPackages;
    }

    public List<String> getHideClasses() {
        return this.hideClasses;
    }

    public void setHideClasses(List<String> hideClasses) {
        this.hideClasses = hideClasses;
    }

    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PluginDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    private ClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            List compileClasspathElements = this.project.getCompileClasspathElements();
            ArrayList<URL> classpathURLs = new ArrayList<URL>();
            for (String element : runtimeClasspathElements) {
                classpathURLs.add(new File(element).toURI().toURL());
            }
            for (String element : compileClasspathElements) {
                classpathURLs.add(new File(element).toURI().toURL());
            }
            URL[] urlArray = classpathURLs.toArray(new URL[classpathURLs.size()]);
            return new URLClassLoader(urlArray, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load project runtime !", e);
        }
    }
}

