/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.maven.plugin.plantuml.generator;

import de.elnarion.util.plantuml.generator.PlantUMLClassDiagramGenerator;
import de.elnarion.util.plantuml.generator.classdiagram.ClassifierType;
import de.elnarion.util.plantuml.generator.classdiagram.VisibilityType;
import de.elnarion.util.plantuml.generator.config.PlantUMLConfigBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class PlantUMLGeneratorMojo
extends AbstractMojo {
    static final String PREFIX = "plantuml-generator.";
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="plantuml-generator.outputDirectory", defaultValue="${project.build.directory}/generated-docs", required=false)
    private File outputDirectory;
    @Parameter(property="plantuml-generator.outputFilename", required=true)
    private String outputFilename;
    @Parameter(property="plantuml-generator.hideFields", defaultValue="false", required=false)
    private boolean hideFields;
    @Parameter(property="plantuml-generator.hideMethods", defaultValue="false", required=false)
    private boolean hideMethods;
    @Parameter(property="plantuml-generator.enableAsciidocWrapper", defaultValue="false", required=false)
    private boolean enableAsciidocWrapper;
    @Parameter(property="plantuml-generator.enableMarkdownWrapper", defaultValue="false", required=false)
    private boolean enableMarkdownWrapper;
    @Parameter(property="plantuml-generator.scanPackages", defaultValue="", required=true)
    private List<String> scanPackages;
    @Parameter(property="plantuml-generator.whitelistRegexp", defaultValue="", required=false)
    private String whitelistRegexp;
    @Parameter(property="plantuml-generator.asciidocDiagramName", defaultValue="", required=false)
    private String asciidocDiagramName;
    @Parameter(property="plantuml-generator.asciidocDiagramImageFormat", defaultValue="png", required=false)
    private String asciidocDiagramImageFormat;
    @Parameter(property="plantuml-generator.asciidocDiagramBlockDelimiter", defaultValue="----", required=false)
    private String asciidocDiagramBlockDelimiter;
    @Parameter(property="plantuml-generator.blacklistRegexp", defaultValue="", required=false)
    private String blacklistRegexp;
    @Parameter(property="plantuml-generator.hideClasses", defaultValue="", required=false)
    private List<String> hideClasses;
    @Parameter(property="plantuml-generator.fieldClassifierListToIgnore", defaultValue="", required=false)
    private List<ClassifierType> fieldClassifierListToIgnore;
    @Parameter(property="plantuml-generator.methodClassifierListToIgnore", defaultValue="", required=false)
    private List<ClassifierType> methodClassifierListToIgnore;
    @Parameter(property="plantuml-generator.removeMethods", defaultValue="false", required=false)
    private boolean removeMethods;
    @Parameter(property="plantuml-generator.addJPAAnnotations", defaultValue="false", required=false)
    private boolean addJPAAnnotations;
    @Parameter(property="plantuml-generator.removeFields", defaultValue="false", required=false)
    private boolean removeFields;
    @Parameter(property="plantuml-generator.fieldBlacklistRegexp", defaultValue="", required=false)
    private String fieldBlacklistRegexp = null;
    @Parameter(property="plantuml-generator.methodBlacklistRegexp", defaultValue="", required=false)
    private String methodBlacklistRegexp = null;
    @Parameter(property="plantuml-generator.maxVisibilityFields", defaultValue="PRIVATE", required=false)
    private VisibilityType maxVisibilityFields = VisibilityType.PRIVATE;
    @Parameter(property="plantuml-generator.maxVisibilityMethods", defaultValue="PRIVATE", required=false)
    private VisibilityType maxVisibilityMethods = VisibilityType.PRIVATE;
    @Parameter(property="plantuml-generator.additionalPlantUmlConfigs", defaultValue="", required=false)
    private List<String> additionalPlantUmlConfigs;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor descriptor;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting plantuml generation ");
        try {
            ClassLoader loader = this.getCompileClassLoader();
            PlantUMLConfigBuilder configBuilder = this.whitelistRegexp == null || "".equals(this.whitelistRegexp) ? new PlantUMLConfigBuilder(this.blacklistRegexp != null && !"".equals(this.blacklistRegexp) ? this.blacklistRegexp : null, this.scanPackages) : new PlantUMLConfigBuilder(this.scanPackages, this.whitelistRegexp);
            configBuilder.withClassLoader(loader).withHideClasses(this.hideClasses).withHideFieldsParameter(this.hideFields).withHideMethods(this.hideMethods).addFieldClassifiersToIgnore(this.fieldClassifierListToIgnore).addMethodClassifiersToIgnore(this.methodClassifierListToIgnore).withRemoveFields(this.removeFields).withRemoveMethods(this.removeMethods).withFieldBlacklistRegexp(this.fieldBlacklistRegexp).withMethodBlacklistRegexp(this.methodBlacklistRegexp).withMaximumFieldVisibility(this.maxVisibilityFields).withMaximumMethodVisibility(this.maxVisibilityMethods).withJPAAnnotations(this.addJPAAnnotations).addAdditionalPlantUmlConfigs(this.additionalPlantUmlConfigs);
            PlantUMLClassDiagramGenerator classDiagramGenerator = new PlantUMLClassDiagramGenerator(configBuilder.build());
            String classDiagramText = classDiagramGenerator.generateDiagramText();
            if (this.enableAsciidocWrapper) {
                classDiagramText = this.createAsciidocWrappedDiagramText(classDiagramText);
            }
            if (this.enableMarkdownWrapper) {
                classDiagramText = this.createMarkdownWrappedDiagramText(classDiagramText);
            }
            this.getLog().debug((CharSequence)"diagram text:");
            this.getLog().debug((CharSequence)classDiagramText);
            this.getLog().info((CharSequence)"Diagram generated.");
            File outputFile = new File(this.outputDirectory.getAbsolutePath() + File.separator + this.outputFilename);
            if (!outputFile.exists()) {
                outputFile.getParentFile().mkdirs();
                boolean created = outputFile.createNewFile();
                if (!created) {
                    this.getLog().error((CharSequence)("Output file " + outputFile.getAbsolutePath() + " could not be created."));
                    return;
                }
            }
            IOUtils.write((String)classDiagramText, (OutputStream)new FileOutputStream(outputFile), (String)this.encoding);
            this.getLog().info((CharSequence)("Diagram written to " + outputFile.getAbsolutePath()));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Exception:" + e.getMessage()));
            this.getLog().error((Throwable)e);
        }
    }

    private String createAsciidocWrappedDiagramText(String paramClassDiagramTextToWrap) {
        StringBuilder builder = new StringBuilder();
        builder.append("[plantuml,");
        if (this.asciidocDiagramName != null && !"".equals(this.asciidocDiagramName)) {
            builder.append(this.asciidocDiagramName);
        } else {
            builder.append(this.outputFilename + "." + this.asciidocDiagramImageFormat);
        }
        builder.append(",");
        builder.append(this.asciidocDiagramImageFormat);
        builder.append("]");
        builder.append(System.lineSeparator());
        builder.append(this.asciidocDiagramBlockDelimiter);
        builder.append(System.lineSeparator());
        builder.append(paramClassDiagramTextToWrap);
        builder.append(System.lineSeparator());
        builder.append(this.asciidocDiagramBlockDelimiter);
        paramClassDiagramTextToWrap = builder.toString();
        return paramClassDiagramTextToWrap;
    }

    private String createMarkdownWrappedDiagramText(String paramClassDiagramTextToWrap) {
        StringBuilder builder = new StringBuilder();
        builder.append("```plantuml");
        builder.append(System.lineSeparator());
        builder.append(paramClassDiagramTextToWrap);
        builder.append(System.lineSeparator());
        builder.append("```");
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public boolean isHideFields() {
        return this.hideFields;
    }

    public void setHideFields(boolean hideFields) {
        this.hideFields = hideFields;
    }

    public boolean isHideMethods() {
        return this.hideMethods;
    }

    public void setHideMethods(boolean hideMethods) {
        this.hideMethods = hideMethods;
    }

    public List<String> getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(List<String> scanPackages) {
        this.scanPackages = scanPackages;
    }

    public List<String> getHideClasses() {
        return this.hideClasses;
    }

    public void setHideClasses(List<String> hideClasses) {
        this.hideClasses = hideClasses;
    }

    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PluginDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getWhitelistRegexp() {
        return this.whitelistRegexp;
    }

    public void setWhitelistRegexp(String whitelistRegexp) {
        this.whitelistRegexp = whitelistRegexp;
    }

    public String getBlacklistRegexp() {
        return this.blacklistRegexp;
    }

    public void setBlacklistRegexp(String blacklistRegexp) {
        this.blacklistRegexp = blacklistRegexp;
    }

    private ClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            List compileClasspathElements = this.project.getCompileClasspathElements();
            ArrayList<URL> classpathURLs = new ArrayList<URL>();
            for (String element : runtimeClasspathElements) {
                classpathURLs.add(new File(element).toURI().toURL());
            }
            for (String element : compileClasspathElements) {
                classpathURLs.add(new File(element).toURI().toURL());
            }
            URL[] urlArray = classpathURLs.toArray(new URL[classpathURLs.size()]);
            return new URLClassLoader(urlArray, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to load project runtime !", e);
        }
    }

    public boolean isEnableAsciidocWrapper() {
        return this.enableAsciidocWrapper;
    }

    public void setEnableAsciidocWrapper(boolean enableAsciidocWrapper) {
        this.enableAsciidocWrapper = enableAsciidocWrapper;
    }

    public boolean isEnableMarkdowncWrapper() {
        return this.enableMarkdownWrapper;
    }

    public void setEnableMarkdownWrapper(boolean enableMarkdownWrapper) {
        this.enableMarkdownWrapper = enableMarkdownWrapper;
    }

    public String getAsciidocDiagramName() {
        return this.asciidocDiagramName;
    }

    public void setAsciidocDiagramName(String asciidocDiagramName) {
        this.asciidocDiagramName = asciidocDiagramName;
    }

    public String getAsciidocDiagramImageFormat() {
        return this.asciidocDiagramImageFormat;
    }

    public void setAsciidocDiagramImageFormat(String asciidocDiagramImageFormat) {
        this.asciidocDiagramImageFormat = asciidocDiagramImageFormat;
    }

    public String getAsciidocDiagramBlockDelimiter() {
        return this.asciidocDiagramBlockDelimiter;
    }

    public void setAsciidocDiagramBlockDelimiter(String asciidocDiagramBlockDelimiter) {
        this.asciidocDiagramBlockDelimiter = asciidocDiagramBlockDelimiter;
    }

    public boolean isAddJPAAnnotations() {
        return this.addJPAAnnotations;
    }

    public void setAddJPAAnnotations(boolean addJPAAnnotations) {
        this.addJPAAnnotations = addJPAAnnotations;
    }
}

