/*
 * Decompiled with CFR 0.152.
 */
package de.elnarion.util.plantuml.generator;

import de.elnarion.util.plantuml.generator.classdiagram.ClassType;
import de.elnarion.util.plantuml.generator.classdiagram.ClassifierType;
import de.elnarion.util.plantuml.generator.classdiagram.RelationshipType;
import de.elnarion.util.plantuml.generator.classdiagram.UMLClass;
import de.elnarion.util.plantuml.generator.classdiagram.UMLField;
import de.elnarion.util.plantuml.generator.classdiagram.UMLMethod;
import de.elnarion.util.plantuml.generator.classdiagram.UMLRelationship;
import de.elnarion.util.plantuml.generator.classdiagram.UMLStereotype;
import de.elnarion.util.plantuml.generator.classdiagram.VisibilityType;
import de.elnarion.util.plantuml.generator.config.PlantUMLConfig;
import de.elnarion.util.plantuml.generator.config.PlantUMLConfigBuilder;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlantUMLClassDiagramGenerator {
    private PlantUMLConfig plantUMLConfig;
    private Map<String, UMLClass> classes;
    private List<Class<?>> resolvedClasses = new ArrayList();
    private Map<UMLClass, List<UMLRelationship>> classesAndRelationships;

    public PlantUMLClassDiagramGenerator(ClassLoader paramClassloader, List<String> paramScanPackages, String paramBlacklistRegexp, List<String> paramHideClasses, boolean paramHideFields, boolean paramHideMethods) {
        this(new PlantUMLConfigBuilder(paramBlacklistRegexp, paramScanPackages).withHideFieldsParameter(paramHideFields).withClassLoader(paramClassloader).withHideMethods(paramHideMethods).withHideClasses(paramHideClasses).build());
    }

    public PlantUMLClassDiagramGenerator(ClassLoader paramClassloader, String paramWhitelistRegexp, List<String> paramHideClasses, boolean paramHideFields, boolean paramHideMethods, List<String> paramScanPackages) {
        this(new PlantUMLConfigBuilder(paramScanPackages, paramWhitelistRegexp).withHideFieldsParameter(paramHideFields).withClassLoader(paramClassloader).withHideMethods(paramHideMethods).withHideClasses(paramHideClasses).build());
    }

    public PlantUMLClassDiagramGenerator(PlantUMLConfig paramPlantUMLConfig) {
        this.plantUMLConfig = paramPlantUMLConfig;
        this.classesAndRelationships = new HashMap<UMLClass, List<UMLRelationship>>();
        this.classes = new HashMap<String, UMLClass>();
    }

    public String generateDiagramText() throws ClassNotFoundException, IOException {
        this.resolvedClasses.clear();
        this.resolvedClasses.addAll(this.getAllDiagramClasses());
        Collections.sort(this.resolvedClasses, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (Class<?> clazz : this.resolvedClasses) {
            this.mapToDomainClasses(clazz);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("@startuml");
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        ArrayList<UMLClass> listToCompare = new ArrayList<UMLClass>();
        listToCompare.addAll(this.classes.values());
        Collections.sort(listToCompare, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        ArrayList<UMLClass> classesList = listToCompare;
        ArrayList<UMLRelationship> relationships = new ArrayList<UMLRelationship>();
        for (UMLClass clazz : classesList) {
            relationships.addAll((Collection)this.classesAndRelationships.get(clazz));
            builder.append(clazz.getDiagramText());
            builder.append(System.lineSeparator());
            builder.append(System.lineSeparator());
        }
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        Collections.sort(relationships, (o1, o2) -> o1.getDiagramText().compareTo(o2.getDiagramText()));
        for (UMLRelationship relationship : relationships) {
            builder.append(relationship.getDiagramText());
            builder.append(System.lineSeparator());
        }
        this.addHideToggles(builder, classesList, relationships);
        builder.append(System.lineSeparator());
        builder.append(System.lineSeparator());
        builder.append("@enduml");
        return builder.toString();
    }

    private void addHideToggles(StringBuilder paramBuilder, Collection<UMLClass> paramClassesList, List<UMLRelationship> relationships) {
        if (paramClassesList != null && !paramClassesList.isEmpty() || !relationships.isEmpty()) {
            if (this.plantUMLConfig.isHideFields()) {
                paramBuilder.append(System.lineSeparator());
                paramBuilder.append("hide fields");
            }
            if (this.plantUMLConfig.isHideMethods()) {
                paramBuilder.append(System.lineSeparator());
                paramBuilder.append("hide methods");
            }
            if (this.plantUMLConfig.getHideClasses() != null && !this.plantUMLConfig.getHideClasses().isEmpty()) {
                for (String hideClass : this.plantUMLConfig.getHideClasses()) {
                    paramBuilder.append(System.lineSeparator());
                    paramBuilder.append("hide ");
                    paramBuilder.append(hideClass);
                }
            }
        }
    }

    private void mapToDomainClasses(Class<?> paramClassObject) {
        if (!this.includeClass(paramClassObject)) {
            return;
        }
        int modifiers = paramClassObject.getModifiers();
        VisibilityType visibilityType = VisibilityType.PUBLIC;
        if (Modifier.isPrivate(modifiers)) {
            visibilityType = VisibilityType.PRIVATE;
        } else if (Modifier.isProtected(modifiers)) {
            visibilityType = VisibilityType.PROTECTED;
        }
        ClassType classType = ClassType.CLASS;
        if (paramClassObject.isAnnotation()) {
            classType = ClassType.ANNOTATION;
        } else if (paramClassObject.isEnum()) {
            classType = ClassType.ENUM;
        } else if (paramClassObject.isInterface()) {
            classType = ClassType.INTERFACE;
        } else if (Modifier.isAbstract(modifiers)) {
            classType = ClassType.ABSTRACT_CLASS;
        }
        ArrayList<UMLStereotype> stereotypes = new ArrayList<UMLStereotype>();
        if (this.plantUMLConfig.isAddJPAAnnotations()) {
            this.addJPAStereotype(paramClassObject, stereotypes);
        }
        UMLClass umlClass = new UMLClass(visibilityType, classType, new ArrayList<UMLField>(), new ArrayList<UMLMethod>(), paramClassObject.getName(), stereotypes);
        ArrayList relationships = new ArrayList();
        this.classesAndRelationships.put(umlClass, relationships);
        this.classes.put(paramClassObject.getName(), umlClass);
        if (classType == ClassType.ENUM) {
            this.addEnumConstants(paramClassObject, umlClass);
        } else {
            this.addFields(paramClassObject.getDeclaredFields(), paramClassObject.getDeclaredMethods(), umlClass);
            this.addMethods(paramClassObject.getDeclaredMethods(), paramClassObject.getDeclaredFields(), umlClass);
        }
        this.addSuperClassRelationship(paramClassObject, umlClass);
        this.addInterfaceRelationship(paramClassObject, umlClass);
        this.addAnnotationRelationship(paramClassObject, umlClass);
    }

    private void addJPAStereotype(Class<?> paramClassObject, List<UMLStereotype> stereotypes) {
        ClassLoader destinationClassloader = this.plantUMLConfig.getDestinationClassloader();
        if (destinationClassloader != null) {
            try {
                this.addStereoTypesForAnnotationClass(paramClassObject, stereotypes, destinationClassloader, "javax.persistence.Entity", "Entity");
                this.addStereoTypesForAnnotationClass(paramClassObject, stereotypes, destinationClassloader, "javax.persistence.Table", "Table");
            }
            catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    private void addStereoTypesForAnnotationClass(Class<?> paramClassObject, List<UMLStereotype> stereotypes, ClassLoader destinationClassloader, String annotationClassName, String annotationName) throws ClassNotFoundException {
        Annotation[] annotations;
        Class<?> tableAnnotation = destinationClassloader.loadClass(annotationClassName);
        for (Annotation annotation : annotations = paramClassObject.getAnnotations()) {
            if (!tableAnnotation.isAssignableFrom(annotation.getClass())) continue;
            this.addAnnotationStereotype(stereotypes, annotation, annotationName);
        }
    }

    private void addAnnotationStereotype(List<UMLStereotype> stereotypes, Annotation annotation, String annotationName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.addAttributeIfExists(annotation, attributes, "name");
        this.addAttributeIfExists(annotation, attributes, "schema");
        UMLStereotype stereotype = new UMLStereotype(annotationName, attributes);
        stereotypes.add(stereotype);
    }

    private void addAttributeIfExists(Annotation annotation, Map<String, String> attributes, String methodname) {
        try {
            Object nameObject;
            Method nameMethod = annotation.getClass().getMethod(methodname, new Class[0]);
            if (nameMethod != null && (nameObject = nameMethod.invoke((Object)annotation, new Object[0])) instanceof String && !((String)nameObject).isEmpty()) {
                attributes.put(methodname, (String)nameObject);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private String getColumnAnnotationString(Annotation annotation, String annotationName) {
        StringBuilder builder = new StringBuilder();
        builder.append("@");
        builder.append(annotationName);
        try {
            Method nameMethod = annotation.getClass().getMethod("name", new Class[0]);
            if (nameMethod != null) {
                builder.append("(\"");
                Object nameObject = nameMethod.invoke((Object)annotation, new Object[0]);
                if (nameObject instanceof String) {
                    builder.append(nameObject);
                }
                builder.append("\")");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
        return builder.toString();
    }

    private void addEnumConstants(Class<?> paramClassObject, UMLClass paramUmlClass) {
        ?[] enumConstants;
        for (Object enumConstant : enumConstants = paramClassObject.getEnumConstants()) {
            UMLField field = new UMLField(ClassifierType.NONE, VisibilityType.PUBLIC, enumConstant.toString(), null, new ArrayList<String>());
            paramUmlClass.addField(field);
        }
    }

    private void addAnnotationRelationship(Class<?> paramClassObject, UMLClass umlClass) {
        Annotation[] annotations = paramClassObject.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!this.includeClass(annotation.getClass())) continue;
                UMLRelationship relationship = new UMLRelationship(null, null, null, paramClassObject.getName(), annotation.getClass().getName(), RelationshipType.ASSOCIATION, new ArrayList<String>());
                this.addRelationship(umlClass, relationship);
            }
        }
    }

    private void addRelationship(UMLClass paramUmlClass, UMLRelationship paramUmlRelationship) {
        ArrayList<UMLRelationship> relationshipList = this.classesAndRelationships.computeIfAbsent(paramUmlClass, k -> new ArrayList());
        if (relationshipList == null) {
            relationshipList = new ArrayList<UMLRelationship>();
            this.classesAndRelationships.put(paramUmlClass, relationshipList);
        }
        relationshipList.add(paramUmlRelationship);
    }

    private void addInterfaceRelationship(Class<?> paramClassObject, UMLClass paramUmlClass) {
        Class<?>[] interfaces = paramClassObject.getInterfaces();
        if (interfaces != null) {
            for (Class<?> interfaceElement : interfaces) {
                if (!this.includeClass(interfaceElement)) continue;
                UMLRelationship relationship = new UMLRelationship(null, null, null, paramClassObject.getName(), interfaceElement.getName(), RelationshipType.REALIZATION, new ArrayList<String>());
                this.addRelationship(paramUmlClass, relationship);
            }
        }
    }

    private void addSuperClassRelationship(Class<?> paramClassObject, UMLClass paramUmlClass) {
        Class<?> superClass = paramClassObject.getSuperclass();
        if (superClass != null && this.includeClass(superClass)) {
            UMLRelationship relationship = new UMLRelationship(null, null, null, paramClassObject.getName(), superClass.getName(), RelationshipType.INHERITANCE, new ArrayList<String>());
            this.addRelationship(paramUmlClass, relationship);
        }
    }

    private void addMethods(Method[] paramDeclaredMethods, Field[] paramDeclaredFields, UMLClass paramUmlClass) {
        if (paramDeclaredMethods != null) {
            for (Method method : paramDeclaredMethods) {
                String methodName = method.getName();
                if ((methodName.startsWith("get") || methodName.startsWith("set") || methodName.startsWith("is")) && paramDeclaredFields != null && this.isGetterOrSetterMethod(method, paramDeclaredFields) || this.plantUMLConfig.isRemoveMethods() || this.plantUMLConfig.getMethodBlacklistRegexp() != null && methodName.matches(this.plantUMLConfig.getMethodBlacklistRegexp())) continue;
                String returnType = method.getReturnType().getName();
                returnType = this.removeJavaLangPackage(returnType);
                Class<?>[] parameterTypes = method.getParameterTypes();
                Map<String, String> parameters = this.convertToParameterStringMap(parameterTypes);
                int modifier = method.getModifiers();
                VisibilityType visibilityType = this.getVisibility(modifier);
                if (!this.visibilityOk(this.plantUMLConfig.getMaxVisibilityMethods(), visibilityType)) continue;
                ClassifierType classifierType = this.getClassifier(modifier);
                if (this.plantUMLConfig.getMethodClassifierToIgnore().contains((Object)classifierType)) continue;
                ArrayList<String> stereotypes = new ArrayList<String>();
                if (method.isAnnotationPresent(Deprecated.class)) {
                    stereotypes.add("deprecated");
                }
                if (Modifier.isSynchronized(modifier)) {
                    stereotypes.add("synchronized");
                }
                UMLMethod umlMethod = new UMLMethod(classifierType, visibilityType, returnType, methodName, parameters, stereotypes);
                paramUmlClass.addMethod(umlMethod);
            }
        }
    }

    private String removeJavaLangPackage(String paramTypeName) {
        if (paramTypeName.startsWith("java.lang.")) {
            paramTypeName = paramTypeName.substring("java.lang.".length(), paramTypeName.length());
        }
        return paramTypeName;
    }

    private ClassifierType getClassifier(int paramModifier) {
        ClassifierType classifierType = ClassifierType.NONE;
        if (Modifier.isStatic(paramModifier)) {
            classifierType = Modifier.isAbstract(paramModifier) ? ClassifierType.ABSTRACT_STATIC : ClassifierType.STATIC;
        } else if (Modifier.isAbstract(paramModifier)) {
            classifierType = ClassifierType.ABSTRACT;
        }
        return classifierType;
    }

    private VisibilityType getVisibility(int paramModifier) {
        VisibilityType visibilityType = VisibilityType.PACKAGE_PRIVATE;
        if (Modifier.isPublic(paramModifier)) {
            visibilityType = VisibilityType.PUBLIC;
        } else if (Modifier.isPrivate(paramModifier)) {
            visibilityType = VisibilityType.PRIVATE;
        } else if (Modifier.isProtected(paramModifier)) {
            visibilityType = VisibilityType.PROTECTED;
        }
        return visibilityType;
    }

    private Map<String, String> convertToParameterStringMap(Class<?>[] paramParameterTypes) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (paramParameterTypes != null) {
            int counter = 1;
            for (Class<?> parameter : paramParameterTypes) {
                String parameterName = parameter.getName();
                if (parameterName.lastIndexOf(46) > 0) {
                    parameterName = parameterName.substring(parameterName.lastIndexOf(46) + 1, parameterName.length());
                }
                parameterName = "param" + parameterName + counter;
                parameters.put(parameterName, this.removeJavaLangPackage(parameter.getName()));
                ++counter;
            }
        }
        return parameters;
    }

    private boolean isGetterOrSetterMethod(Method paramMethod, Field[] paramDeclaredFields) {
        String methodName = paramMethod.getName();
        if (methodName.startsWith("get")) {
            methodName = methodName.substring(3, methodName.length());
        } else if (methodName.startsWith("is")) {
            methodName = methodName.substring(2, methodName.length());
        } else if (methodName.startsWith("set")) {
            methodName = methodName.substring(3, methodName.length());
        }
        for (Field field : paramDeclaredFields) {
            String fieldName = field.getName();
            if (!fieldName.equalsIgnoreCase(methodName)) continue;
            return true;
        }
        return false;
    }

    private void addFields(Field[] paramDeclaredFields, Method[] paramDeclaredMethods, UMLClass paramUmlClass) {
        if (paramDeclaredFields != null) {
            for (Field field : paramDeclaredFields) {
                Class<?> type = field.getType();
                boolean relationshipAdded = this.addAggregationRelationship(paramUmlClass, field, paramDeclaredMethods);
                if (relationshipAdded) continue;
                if (this.includeClass(type)) {
                    ArrayList<String> annotations = new ArrayList<String>();
                    this.addJPAFieldAnnotationsToList(field, paramDeclaredMethods, annotations);
                    UMLRelationship relationship = new UMLRelationship(null, null, field.getName(), field.getDeclaringClass().getName(), type.getName(), RelationshipType.DIRECTED_ASSOCIATION, annotations);
                    this.addRelationship(paramUmlClass, relationship);
                    continue;
                }
                this.addFieldToUMLClass(paramUmlClass, field, type, paramDeclaredMethods);
            }
        }
    }

    private void addFieldToUMLClass(UMLClass paramUmlClass, Field field, Class<?> type, Method[] paramDeclaredMethods) {
        if (this.plantUMLConfig.isRemoveFields()) {
            return;
        }
        if (this.plantUMLConfig.getFieldBlacklistRegexp() != null && field.getName().matches(this.plantUMLConfig.getFieldBlacklistRegexp())) {
            return;
        }
        int modifier = field.getModifiers();
        ArrayList<String> annotationStringList = new ArrayList<String>();
        if (this.plantUMLConfig.isAddJPAAnnotations()) {
            this.addJPAFieldAnnotationsToList(field, paramDeclaredMethods, annotationStringList);
        }
        ClassifierType classifierType = this.getClassifier(modifier);
        if (this.plantUMLConfig.getFieldClassifierToIgnore().contains((Object)classifierType)) {
            return;
        }
        VisibilityType visibilityType = this.getVisibility(modifier);
        if (this.hasGetterAndSetterMethod(field.getName(), paramDeclaredMethods)) {
            visibilityType = VisibilityType.PUBLIC;
        }
        if (!this.visibilityOk(this.plantUMLConfig.getMaxVisibilityFields(), visibilityType)) {
            return;
        }
        UMLField umlField = new UMLField(classifierType, visibilityType, field.getName(), this.removeJavaLangPackage(type.getName()), annotationStringList);
        paramUmlClass.addField(umlField);
    }

    private void addJPAFieldAnnotationsToList(Field field, Method[] paramDeclaredMethods, List<String> annotationStringList) {
        ClassLoader destinationClassloader = this.plantUMLConfig.getDestinationClassloader();
        if (destinationClassloader != null) {
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.Column");
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.Id");
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.Transient");
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.OneToOne");
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.OneToMany");
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.ManyToMany");
            this.addJPAFieldAnnotationClassToList(field, paramDeclaredMethods, annotationStringList, destinationClassloader, "javax.persistence.ManyToOne");
        }
    }

    private void addJPAFieldAnnotationClassToList(Field field, Method[] paramDeclaredMethods, List<String> annotationStringList, ClassLoader destinationClassloader, String paramAnnotationClassname) {
        try {
            boolean foundAnnotation = false;
            Class<?> columnAnnotation = destinationClassloader.loadClass(paramAnnotationClassname);
            Annotation[] annotations = field.getAnnotations();
            for (Annotation annotation : annotations) {
                if (!columnAnnotation.isAssignableFrom(annotation.getClass())) continue;
                annotationStringList.add(this.getColumnAnnotationString(annotation, columnAnnotation.getSimpleName()));
                foundAnnotation = true;
            }
            if (!foundAnnotation) {
                for (Method declaredMethod : paramDeclaredMethods) {
                    if (!this.isGetterOrSetterMethod(declaredMethod, new Field[]{field})) continue;
                    for (Annotation annotation : annotations = declaredMethod.getAnnotations()) {
                        if (!columnAnnotation.isAssignableFrom(annotation.getClass())) continue;
                        annotationStringList.add(this.getColumnAnnotationString(annotation, columnAnnotation.getSimpleName()));
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
    }

    private boolean visibilityOk(VisibilityType maxVisibilityFields, VisibilityType visibilityType) {
        if (maxVisibilityFields != null) {
            if (maxVisibilityFields.equals((Object)VisibilityType.PUBLIC) && !visibilityType.equals((Object)VisibilityType.PUBLIC)) {
                return false;
            }
            if (maxVisibilityFields.equals((Object)VisibilityType.PROTECTED) && !visibilityType.equals((Object)VisibilityType.PUBLIC) && !visibilityType.equals((Object)VisibilityType.PROTECTED)) {
                return false;
            }
            if (maxVisibilityFields.equals((Object)VisibilityType.PACKAGE_PRIVATE) && !visibilityType.equals((Object)VisibilityType.PUBLIC) && !visibilityType.equals((Object)VisibilityType.PACKAGE_PRIVATE) && !visibilityType.equals((Object)VisibilityType.PROTECTED)) {
                return false;
            }
        }
        return true;
    }

    private boolean hasGetterAndSetterMethod(String paramFieldName, Method[] paramDeclaredMethods) {
        String getterMethodName = "get" + paramFieldName;
        String setterMethodName = "set" + paramFieldName;
        String isMethodName = "is" + paramFieldName;
        boolean hasGetterMethod = false;
        boolean hasSetterMethod = false;
        if (paramDeclaredMethods != null) {
            for (Method method : paramDeclaredMethods) {
                String methodName = method.getName();
                if (methodName.equalsIgnoreCase(getterMethodName) || methodName.equalsIgnoreCase(isMethodName)) {
                    hasGetterMethod = true;
                } else if (methodName.equalsIgnoreCase(setterMethodName)) {
                    hasSetterMethod = true;
                }
                if (!hasSetterMethod || !hasGetterMethod) continue;
                return true;
            }
        }
        return false;
    }

    private boolean addAggregationRelationship(UMLClass paramUmlClass, Field paramField, Method[] paramDeclaredMethods) {
        Type[] actualTypeArguments;
        Class<?> type = paramField.getType();
        Type genericType = paramField.getGenericType();
        boolean isRelationshipAggregation = false;
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && (((ParameterizedType)genericType).getRawType().equals(Set.class) || ((ParameterizedType)genericType).getRawType().equals(List.class)) && (actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments()) != null) {
            for (Type typeArgument : actualTypeArguments) {
                Class<?> typeArgumentClass = this.getClassForType(typeArgument);
                if (typeArgumentClass == null || !this.includeClass(typeArgumentClass)) continue;
                ArrayList<String> annotations = new ArrayList<String>();
                this.addJPAFieldAnnotationsToList(paramField, paramDeclaredMethods, annotations);
                UMLRelationship relationship = new UMLRelationship("1", "0..*", paramField.getName(), paramField.getDeclaringClass().getName(), typeArgumentClass.getName(), RelationshipType.AGGREGATION, annotations);
                this.addRelationship(paramUmlClass, relationship);
                isRelationshipAggregation = true;
            }
        }
        return isRelationshipAggregation;
    }

    private Class<?> getClassForType(Type paramType) {
        Class typeArgumentClass = null;
        if (paramType instanceof ParameterizedType) {
            if (((ParameterizedType)paramType).getRawType() instanceof Class) {
                typeArgumentClass = (Class)((ParameterizedType)paramType).getRawType();
            }
        } else if (paramType instanceof Class) {
            typeArgumentClass = (Class)paramType;
        } else if (paramType instanceof TypeVariable) {
            // empty if block
        }
        return typeArgumentClass;
    }

    private Set<Class<?>> getAllDiagramClasses() {
        if (this.plantUMLConfig.getWhitelistRegexp() == null) {
            return this.getAllClassesInScanPackages();
        }
        return this.getAllClassesFromWhiteList();
    }

    private Set<Class<?>> getAllClassesFromWhiteList() {
        try (ScanResult scanResult = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.plantUMLConfig.getDestinationClassloader()}).enableClassInfo().whitelistPackages(this.plantUMLConfig.getScanPackages().toArray(new String[this.plantUMLConfig.getScanPackages().size()])).scan();){
            ClassInfoList allClasses = scanResult.getAllClasses();
            ClassInfoList result = allClasses.filter(ci -> ci.getName().matches(this.plantUMLConfig.getWhitelistRegexp()));
            HashSet hashSet = new HashSet(result.loadClasses());
            return hashSet;
        }
    }

    private Set<Class<?>> getAllClassesInScanPackages() {
        try (ScanResult scanResult = new ClassGraph().overrideClassLoaders(new ClassLoader[]{this.plantUMLConfig.getDestinationClassloader()}).enableClassInfo().whitelistPackages(this.plantUMLConfig.getScanPackages().toArray(new String[this.plantUMLConfig.getScanPackages().size()])).scan();){
            ClassInfoList allClasses = scanResult.getAllClasses();
            if (this.plantUMLConfig.getBlacklistRegexp() != null) {
                ClassInfoList result = allClasses.filter(ci -> !ci.getName().matches(this.plantUMLConfig.getBlacklistRegexp()));
                HashSet hashSet = new HashSet(result.loadClasses());
                return hashSet;
            }
            HashSet hashSet = new HashSet(allClasses.loadClasses());
            return hashSet;
        }
    }

    private boolean includeClass(Class<?> paramClass) {
        return this.resolvedClasses.contains(paramClass);
    }
}

