/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import java.util.Objects;

public interface ChannelId<T> {
    public static ChannelId<Boolean> booleanChannel(String id) {
        return ChannelId.channel(id, Boolean.class);
    }

    public static <T> ChannelId<T> channel(String id, Class<T> datatype) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(datatype);
        return new StringId<T>(id, datatype);
    }

    public static ChannelId<Integer> intChannel(String id) {
        return ChannelId.channel(id, Integer.class);
    }

    public static ChannelId<String> stringChannel(String id) {
        return ChannelId.channel(id, String.class);
    }

    public static class StringId<T>
    implements ChannelId<T> {
        private final String id;
        private final Class<T> datatype;

        StringId(String id, Class<T> datatype) {
            this.id = id;
            this.datatype = datatype;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StringId other = (StringId)obj;
            return this.datatype == other.datatype && this.id.equals(other.id);
        }

        public int hashCode() {
            return 17 * this.datatype.hashCode() + this.id.hashCode();
        }

        public String toString() {
            return String.format("%s<%s>", this.id, this.datatype.getSimpleName());
        }
    }
}

