/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Channel;
import de.esoco.coroutine.ChannelId;
import de.esoco.coroutine.Coroutine;
import de.esoco.coroutine.CoroutineContext;
import de.esoco.coroutine.CoroutineEvent;
import de.esoco.coroutine.CoroutineException;
import de.esoco.coroutine.CoroutineScope;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.coroutine.Coroutines;
import de.esoco.coroutine.Subroutine;
import de.esoco.coroutine.Suspension;
import de.esoco.lib.concurrent.RunLock;
import de.esoco.lib.event.Event;
import de.esoco.lib.event.EventDispatcher;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.type.StandardTypes;

public class Continuation<T>
extends RelatedObject
implements Executor {
    private static final AtomicLong aNextId = new AtomicLong(1L);
    private final CoroutineScope scope;
    private final long id = aNextId.getAndIncrement();
    private final Deque<Coroutine<?, ?>> coroutineStack = new ArrayDeque();
    private final CountDownLatch finishSignal = new CountDownLatch(1);
    private final RunLock stateLock = new RunLock();
    BiConsumer<Suspension<?>, Boolean> suspensionListener = null;
    BiConsumer<CoroutineStep<?, ?>, Continuation<?>> fStepListener = null;
    private T result = null;
    private boolean callChainComplete = false;
    private boolean cancelled = false;
    private boolean finished = false;
    private Throwable error = null;
    private CompletableFuture<?> currentExecution = null;
    private Suspension<?> currentSuspension = null;
    private Consumer<Continuation<T>> runWhenDone;
    private Consumer<Continuation<T>> runOnCancel;
    private Consumer<Continuation<T>> runOnError;

    public Continuation(CoroutineScope scope, Coroutine<?, T> coroutine) {
        this.scope = scope;
        this.coroutineStack.push(coroutine);
        this.suspensionListener = this.getConfiguration(Coroutines.COROUTINE_SUSPENSION_LISTENER);
        this.fStepListener = this.getConfiguration(Coroutines.COROUTINE_STEP_LISTENER);
        scope.coroutineStarted(this);
        this.notifyListeners(CoroutineEvent.EventType.STARTED);
    }

    public void await() {
        try {
            this.finishSignal.await();
        }
        catch (InterruptedException e) {
            throw new CoroutineException(e);
        }
    }

    public boolean await(long timeout, TimeUnit unit) {
        try {
            return this.finishSignal.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new CoroutineException(e);
        }
    }

    public void cancel() {
        this.stateLock.runLocked(() -> {
            if (!this.finished) {
                this.cancelled = true;
                this.finish(null);
                if (this.runOnCancel != null) {
                    this.runOnCancel.accept(this);
                }
            }
        });
        if (this.currentSuspension != null) {
            this.currentSuspension.cancel();
        }
        if (this.callChainComplete && this.currentExecution != null) {
            this.currentExecution.cancel(false);
        }
    }

    public final CoroutineContext context() {
        return this.scope.context();
    }

    public final <V> void continueAccept(CompletableFuture<V> rPreviousExecution, Consumer<V> fNext) {
        if (!this.cancelled) {
            this.currentExecution = ((CompletableFuture)rPreviousExecution.thenAcceptAsync((Consumer)fNext, (Executor)this)).exceptionally(this::fail);
        } else if (this.currentExecution != null) {
            this.currentExecution.cancel(false);
        }
    }

    public final <I, O> void continueApply(CompletableFuture<I> previousExecution, Function<I, O> next, CoroutineStep<O, ?> nextStep) {
        if (!this.cancelled) {
            CompletionStage rNextExecution = previousExecution.thenApplyAsync(next, (Executor)this);
            this.currentExecution = rNextExecution;
            if (nextStep != null) {
                nextStep.runAsync(rNextExecution, null, this);
            } else {
                ((CompletableFuture)rNextExecution).exceptionally(this::fail);
                this.callChainComplete = true;
            }
        } else if (this.currentExecution != null) {
            this.currentExecution.cancel(false);
        }
    }

    public void errorHandled() {
        if (this.error == null) {
            throw new IllegalStateException("No error exists");
        }
        this.scope.continuationErrorHandled(this);
    }

    @Override
    public void execute(Runnable command) {
        this.context().getExecutor().execute(command);
    }

    public <O> O fail(Throwable error) {
        if (!this.finished) {
            this.error = error;
            this.scope.fail(this);
            this.cancel();
            ((Consumer)this.getConfiguration(Coroutines.EXCEPTION_HANDLER, null)).accept(error);
            if (this.runOnError != null) {
                this.runOnError.accept(this);
            }
        }
        return null;
    }

    public final <C> Channel<C> getChannel(ChannelId<C> id) {
        return this.scope.getChannel(id);
    }

    public <V> V getConfiguration(RelationType<V> configType) {
        return this.getConfiguration(configType, null);
    }

    public <V> V getConfiguration(RelationType<V> configType, V defaultValue) {
        Object rValue = defaultValue;
        if (this.hasRelation(configType)) {
            rValue = this.get(configType);
        } else if (this.scope.hasRelation(configType)) {
            rValue = this.scope.get(configType);
        } else if (this.scope.context().hasRelation(configType)) {
            rValue = this.scope.context().get(configType);
        } else {
            Coroutine<?, ?> rCoroutine = this.getCurrentCoroutine();
            if (defaultValue == null || rCoroutine.hasRelation(configType)) {
                rValue = rCoroutine.get(configType);
            }
        }
        return rValue;
    }

    public final Coroutine<?, ?> getCurrentCoroutine() {
        return this.coroutineStack.peek();
    }

    public final Suspension<?> getCurrentSuspension() {
        return this.currentSuspension;
    }

    public Throwable getError() {
        return this.error;
    }

    public T getResult() {
        try {
            this.finishSignal.await();
        }
        catch (InterruptedException e) {
            throw new CoroutineException(e);
        }
        return this.getResultImpl();
    }

    public T getResult(long timeout, TimeUnit unit) {
        try {
            if (!this.finishSignal.await(timeout, unit)) {
                throw new CoroutineException("Timeout reached", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            throw new CoroutineException(e);
        }
        return this.getResultImpl();
    }

    public <V> V getState(RelationType<V> stateType) {
        return this.getState(stateType, null);
    }

    public <V> V getState(RelationType<V> stateType, V defaultValue) {
        Coroutine<?, ?> coroutine = this.getCurrentCoroutine();
        Object value = defaultValue;
        if (coroutine.hasRelation(stateType)) {
            value = coroutine.get(stateType);
        } else if (this.hasRelation(stateType)) {
            value = this.get(stateType);
        } else if (this.scope.hasRelation(stateType)) {
            value = this.scope.get(stateType);
        }
        return value;
    }

    public final long id() {
        return this.id;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Continuation<T> onCancel(Consumer<Continuation<T>> runOnCancel) {
        this.stateLock.runLocked(() -> {
            if (this.cancelled && this.error == null) {
                runOnCancel.accept(this);
            } else {
                this.runOnCancel = runOnCancel;
            }
        });
        return this;
    }

    public Continuation<T> onError(Consumer<Continuation<T>> runOnError) {
        this.stateLock.runLocked(() -> {
            if (this.cancelled && this.error != null) {
                runOnError.accept(this);
            } else {
                this.runOnError = runOnError;
            }
        });
        return this;
    }

    public Continuation<T> onFinish(Consumer<Continuation<T>> runWhenDone) {
        this.stateLock.runLocked(() -> {
            this.runWhenDone = runWhenDone;
            if (this.finished && !this.cancelled) {
                runWhenDone.accept(this);
            }
        });
        return this;
    }

    public final CoroutineScope scope() {
        return this.scope;
    }

    public <V> Suspension<V> suspend(CoroutineStep<?, V> suspendingStep, CoroutineStep<V, ?> suspendedStep) {
        return this.suspendTo(new Suspension<V>(suspendingStep, suspendedStep, this));
    }

    public <V> Suspension<V> suspendTo(Suspension<V> suspension) {
        assert (this.currentSuspension == null);
        this.scope.addSuspension(suspension);
        this.currentSuspension = suspension;
        this.currentExecution = null;
        if (this.suspensionListener != null) {
            this.suspensionListener.accept(this.currentSuspension, true);
        }
        return suspension;
    }

    public String toString() {
        return String.format("%s-%d[%s]", this.getCurrentCoroutine().get(StandardTypes.NAME), this.id, this.result);
    }

    void finish(T result) {
        assert (!this.finished);
        assert (this.coroutineStack.size() == 1);
        try {
            this.result = result;
            this.stateLock.runLocked(() -> {
                this.finished = true;
            });
            this.finishSignal.countDown();
            this.scope.coroutineFinished(this);
            this.notifyListeners(CoroutineEvent.EventType.FINISHED);
            if (!this.cancelled && this.runWhenDone != null) {
                this.runWhenDone.accept(this);
            }
        }
        finally {
            Consumer errorHandler = this.getConfiguration(Coroutines.EXCEPTION_HANDLER, null);
            Coroutines.closeManagedResources(this.getCurrentCoroutine(), errorHandler);
            Coroutines.closeManagedResources((Relatable)this, errorHandler);
        }
    }

    final <V> void resumeAsync(CoroutineStep<V, ?> resumeStep, V value) {
        if (!this.cancelled) {
            CompletableFuture<Object> aResumeExecution = CompletableFuture.supplyAsync(() -> value, this);
            this.currentExecution = aResumeExecution;
            resumeStep.runAsync(aResumeExecution, null, this);
        } else if (this.currentExecution != null) {
            this.currentExecution.cancel(false);
        }
    }

    void subroutineFinished() {
        Coroutines.closeManagedResources(this.getCurrentCoroutine(), this.getConfiguration(Coroutines.EXCEPTION_HANDLER, null));
        this.coroutineStack.pop();
    }

    void subroutineStarted(Subroutine<?, ?, ?> subroutine) {
        this.coroutineStack.push(subroutine);
    }

    <I> void suspensionResumed(Suspension<I> suspension) {
        assert (this.currentSuspension == suspension);
        if (!this.isCancelled() && this.suspensionListener != null) {
            this.suspensionListener.accept(this.currentSuspension, false);
        }
        this.currentSuspension = null;
    }

    final void trace(CoroutineStep<?, ?> step) {
        if (this.fStepListener != null) {
            this.fStepListener.accept(step, this);
        }
    }

    private T getResultImpl() {
        if (this.cancelled) {
            if (this.error != null) {
                if (this.error instanceof CoroutineException) {
                    throw (CoroutineException)this.error;
                }
                throw new CoroutineException(this.error);
            }
            throw new CancellationException();
        }
        return this.result;
    }

    private void notifyListeners(CoroutineEvent.EventType type) {
        Relatable[] rSources;
        for (Relatable rSource : rSources = new Relatable[]{this.getCurrentCoroutine(), this.scope, this.scope.context()}) {
            if (!rSource.hasRelation(Coroutines.COROUTINE_LISTENERS)) continue;
            ((EventDispatcher)rSource.get(Coroutines.COROUTINE_LISTENERS)).dispatch((Event)new CoroutineEvent(this, type));
        }
    }
}

