/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.coroutine;

import de.esoco.coroutine.Continuation;
import de.esoco.coroutine.CoroutineScope;
import de.esoco.coroutine.CoroutineStep;
import de.esoco.lib.expression.Predicate;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.obrel.core.FluentRelatable;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.filter.RelationFilters;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class Coroutine<I, O>
extends RelatedObject
implements FluentRelatable<Coroutine<I, O>> {
    private StepChain<I, ?, O> code;

    public Coroutine(CoroutineStep<I, O> firstStep) {
        Objects.requireNonNull(firstStep);
        this.init(new StepChain(firstStep, new FinishStep()), null);
    }

    Coroutine() {
    }

    private Coroutine(Coroutine<I, O> other) {
        this.init(other.code, other);
    }

    private <T> Coroutine(Coroutine<I, T> other, CoroutineStep<T, O> nextStep) {
        Objects.requireNonNull(nextStep);
        this.init(other.code.then(nextStep), other);
    }

    public static <I, O> Coroutine<I, O> first(CoroutineStep<I, O> step) {
        return new Coroutine<I, O>(step);
    }

    public static <I, O> Coroutine<I, O> first(String stepName, CoroutineStep<I, O> step) {
        return Coroutine.first((CoroutineStep)step.with(StandardTypes.NAME, stepName));
    }

    public Continuation<O> runAsync(CoroutineScope scope, I input) {
        Coroutine<I, O> aRunCoroutine = new Coroutine<I, O>(this);
        Continuation<O> aContinuation = new Continuation<O>(scope, aRunCoroutine);
        CompletableFuture<Object> fExecution = CompletableFuture.supplyAsync(() -> input, aContinuation);
        aRunCoroutine.code.runAsync(fExecution, null, aContinuation);
        return aContinuation;
    }

    public Continuation<O> runBlocking(CoroutineScope scope, I input) {
        Coroutine<I, O> aRunCoroutine = new Coroutine<I, O>(this);
        Continuation<O> aContinuation = new Continuation<O>(scope, aRunCoroutine);
        aRunCoroutine.code.runBlocking(input, aContinuation);
        return aContinuation;
    }

    public <T> Coroutine<I, T> then(CoroutineStep<O, T> step) {
        return new Coroutine<I, T>(this, step);
    }

    public <T> Coroutine<I, T> then(String stepName, CoroutineStep<O, T> step) {
        return this.then((CoroutineStep)step.with(StandardTypes.NAME, stepName));
    }

    public String toString() {
        return String.format("%s[%s]", new Object[]{this.get(StandardTypes.NAME), this.code});
    }

    StepChain<I, ?, O> getCode() {
        return this.code;
    }

    void init(StepChain<I, ?, O> code, Coroutine<?, ?> other) {
        this.code = code;
        this.set(StandardTypes.NAME, ((Object)((Object)this)).getClass().getSimpleName());
        if (other != null) {
            ObjectRelations.copyRelations(other, (Relatable)this, (boolean)true, (Predicate)RelationFilters.ifTypeNot((RelationType)MetaTypes.IMMUTABLE));
        }
    }

    void terminate(Continuation<?> continuation) {
        this.code.getLastStep().runAsync(CompletableFuture.supplyAsync(() -> null, continuation), null, continuation);
    }

    static class StepChain<I, T, O>
    extends CoroutineStep<I, O> {
        CoroutineStep<I, T> step;
        CoroutineStep<T, O> next;

        private StepChain(CoroutineStep<I, T> step, CoroutineStep<T, O> next) {
            this.step = step;
            this.next = next;
        }

        @Override
        public void runAsync(CompletableFuture<I> previousExecution, CoroutineStep<O, ?> nextStep, Continuation<?> continuation) {
            if (!continuation.isCancelled()) {
                try {
                    continuation.trace(this.step);
                    this.step.runAsync(previousExecution, this.next, continuation);
                }
                catch (Throwable e) {
                    continuation.fail(e);
                }
            }
        }

        @Override
        public String toString() {
            return this.step + " -> " + this.next;
        }

        @Override
        protected O execute(I input, Continuation<?> continuation) {
            if (continuation.isCancelled()) {
                return null;
            }
            try {
                continuation.trace(this.step);
                return this.next.execute(this.step.execute(input, continuation), continuation);
            }
            catch (Throwable e) {
                continuation.fail(e);
                return null;
            }
        }

        CoroutineStep<?, ?> getLastStep() {
            if (this.next instanceof StepChain) {
                return ((StepChain)this.next).getLastStep();
            }
            return this.next;
        }

        <R> StepChain<I, T, R> then(CoroutineStep<O, R> step) {
            StepChain<I, T, O> aChainedInvocation = new StepChain<I, T, O>(this.step, null);
            aChainedInvocation.next = this.next instanceof StepChain ? ((StepChain)this.next).then(step) : new StepChain<O, R, O>(step, this.next);
            return aChainedInvocation;
        }

        <R> StepChain<I, T, R> withLastStep(CoroutineStep<?, R> step) {
            StepChain<I, T, O> aChainedInvocation = new StepChain<I, T, O>(this.step, null);
            aChainedInvocation.next = this.next instanceof StepChain ? ((StepChain)this.next).withLastStep(step) : step;
            return aChainedInvocation;
        }
    }

    static class FinishStep<T>
    extends CoroutineStep<T, T> {
        FinishStep() {
        }

        @Override
        protected T execute(T input, Continuation<?> continuation) {
            continuation.finish(input);
            return input;
        }
    }
}

